package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.DataHandler;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.RestoreAlteredFieldsI;
import com.ibm.ie.reeng.rt.common.view.RestoreAlteredFieldsO;

/**
 * This clears all altered field flags for the TransmuteDialog specified in the
 * input view.
 * Use of this component does not change the value in a field; it just resets 
 * its status to unaltered.
 */
public class RestoreAlteredFields extends SystemComponent
{
    public RestoreAlteredFields() { }

    /**
     * Input view.
     */
    public RestoreAlteredFieldsI in = new RestoreAlteredFieldsI();

    public void clearInputView() { in.clear(); }

    /**
     * Output view.
     */
    public RestoreAlteredFieldsO out = new RestoreAlteredFieldsO();

    protected void clearOutputView() { out.clear(); }

    
    private static class Deferred extends DeferredComponent
    {
        private String windowLongName;

        public Deferred(String windowLongName)
        {
            this.windowLongName = windowLongName;
        }

        public void use(TransmuteDialog dialog)
        {
            if (!dialog.getLongName().equals(windowLongName))
                dialog = TransmuteDialog.findWindow(windowLongName);
        
            if (dialog == null) return; // Error has been reported by find.

            dialog.restoreAlteredFields();
        }
    }
            
    protected void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(in.windowLongName));

        out.returnCode = ReturnCodes.SUCCESS;
    }
    
}
