package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.TransmuteTableModel;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsTblInitSizeI;
import com.ibm.ie.reeng.rt.common.view.HpsTblInitSizeO;

import java.awt.Component;


/**
 * Note: this component is not listed as a HPS deferred component, but
 * in use its behavior indicates it must be one.
 */
public class HpsTblInitSize extends SystemComponent
{
    /** Input view. */
    public HpsTblInitSizeI in = new HpsTblInitSizeI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public HpsTblInitSizeO out = new HpsTblInitSizeO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String identifier;
        private int virtualSize;
        private int backBuffer;


        public Deferred(String identifier, int virtualSize, int backBuffer)
        {
            this.identifier = identifier;
            this.virtualSize = virtualSize;
            this.backBuffer = backBuffer;
        }


        public void use(TransmuteDialog dialog)
        {
            TransmuteTable table = (TransmuteTable)
                dialog.findChildByIdentifier(identifier);

            if (table == null) return; // Error has been reported by find.

            table.resetState(); // Clear out any previous internal state.

            TransmuteTableModel model = table.getTransmuteTableModel();

            model.setVirtualRowCount(virtualSize);
            model.setBackBuffer(backBuffer);

            table.dispatchInitEvent();

            // Note: while HPS_TBL_INIT_SIZE is very similar to
            // SET_VIRTUAL_LISTBOX_SIZE only HPS_TBL_INIT_SIZE
            // causes an INIT event to be dispatched.
        }
    }


    public void execute()
    {
        in.dump();

        // If backBuffer is not set it defaults to 1.
        if (in.hpsBackBuffer == 0) in.hpsBackBuffer = 1;

        TransmuteDialog.addDeferred(new Deferred(
            in.hpsItemId,
            in.hpsVirtualSize,
            in.hpsBackBuffer));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
