package com.ibm.ie.reeng.rt.client.component;

import javax.swing.Icon;

import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteBitmap;
import com.ibm.ie.reeng.rt.client.TransmuteButton;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.Log;

import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsSetBitmapFileI;
import com.ibm.ie.reeng.rt.common.view.HpsSetBitmapFileO;


public class HpsSetBitmapFile extends SystemComponent
{
    public HpsSetBitmapFile() { }

    /**
     * Input view.
     */
    public HpsSetBitmapFileI in = new HpsSetBitmapFileI();

    public void clearInputView() { in.clear(); }

    /**
     * Output view.
     */
    public HpsSetBitmapFileO out = new HpsSetBitmapFileO();

    protected void clearOutputView() { out.clear(); }
    
    private static class Deferred extends DeferredComponent
    {
        private String sHpsItemId;
        private String sHpsBitmapName;

        public Deferred(String sHpsItemId, String sHpsBitmapName)
        {
            this.sHpsItemId = sHpsItemId;
            this.sHpsBitmapName = sHpsBitmapName;
        }

        public void use(TransmuteDialog dialog)
        {    
			// get the component by its id
			java.awt.Component child = dialog.findChildByIdentifier(sHpsItemId);
			
			if(child == null)
			{
	        	Log.information(this,"HPS_SET_BITMAP_FILE no Hps Item with the id = "+sHpsItemId);
	        	return;				
			}
	         
	        // Check if the component is a TransmuteBitmap
	        if((child instanceof TransmuteBitmap || child instanceof TransmuteButton))
	        {
	        	// Try the .png reference first
				sHpsBitmapName = normalizeToValidFilename(sHpsBitmapName,"png");				
	        	Icon newHpsBitmapImage = TransmuteDialog.createIcon(sHpsBitmapName);
	        	
	        	if(newHpsBitmapImage != null)
					((TransmuteBitmap)child).setIcon(newHpsBitmapImage);				
				else
				{
					// .png failed, try to load a .bmp file 
					sHpsBitmapName = normalizeToValidFilename(sHpsBitmapName,"bmp");
					newHpsBitmapImage = TransmuteDialog.createIcon(sHpsBitmapName);
					
					if(newHpsBitmapImage!=null)
					{
						if(child instanceof TransmuteBitmap)
							((TransmuteBitmap)child).setIcon(newHpsBitmapImage);
						else 
							((TransmuteButton)child).setIcon(newHpsBitmapImage);
					}						
					else
					{
						Log.information(this, "HPS_SET_BITMAP_FILE cannot create image for HPSItem("
										  +sHpsItemId+") named \""+sHpsBitmapName+"\"");															
					}
				}
	        }	        
	        else
	        {
	        	Log.information(this,"HPS_SET_BITMAP_FILE attempting to change a bitmap, but the component "+
	        	                     "is not the right type. Component = "+child);
	        }
        }

        /**
         * Normalize the filename to a file with the specified extension
         * @param filename
         * @param fileExtension
         * @return
         */
		private final String normalizeToValidFilename(String filename,
													  String fileExtension)
		{
			if(filename.endsWith("."+fileExtension)) return filename;
        	
			if(filename.indexOf('.')==-1)
			{	
				filename=filename+"."+fileExtension; 
			} 
			else
			{
				filename = filename.substring(filename.indexOf('.'));
				filename=filename+"."+fileExtension;
			}        	        		
			return filename;        	
		}        
    }
    
    protected void execute()
    {
		// log the input view attributes
		in.dump();
    	
        TransmuteDialog.addDeferred(new Deferred(
            in.hpsItemId,
            in.hpsBitmapName));    	
            		
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
