package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.Component;
import com.ibm.ie.reeng.rt.common.Log;

import com.ibm.ie.reeng.rt.common.set.ReturnCodes;

import com.ibm.ie.reeng.rt.common.view.HpsEventPostToChildI;
import com.ibm.ie.reeng.rt.common.view.HpsEventPostToChildO;

import com.ibm.ie.reeng.rt.client.Rule;
import com.ibm.ie.reeng.rt.common.LocalRule;

/**
 * Currently, we ignore the EVENT_DEST parameter.  Therefore, you
 * can only send an event to the one and only detached child rule
 */

public class HpsEventPostToChild extends Component
{
    public HpsEventPostToChild() { }

    /**
     * Input view.
     */
    public HpsEventPostToChildI in = new HpsEventPostToChildI();

    public void clearInputView() { in.clear(); }

    /**
     * Output view.
     */
    public HpsEventPostToChildO out = new HpsEventPostToChildO();

    protected void clearOutputView() { out.clear(); }

    protected void execute()
    {
        Rule detachedChild=((Rule)getCallingRule()).getDetachedChild();

        if (detachedChild==null)
        {
            // JP: Is this correct?
            out.returnCode=ReturnCodes.FAILURE;
            return;
        }
        
        Rule.Event event=new Rule.Event(in.eventName,
                                        in.eventView,
                                        in.eventParam,
                                        getCallingRule().getHpsName());

        detachedChild.postEvent(event);
                
        out.returnCode = ReturnCodes.SUCCESS;                            
    }
}
