package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.view.GetCurrentDateTimeO;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * This component gets the current date and time. The current date is
 * stored in an int field of the output view as <code>(currentHour*10000
 * + currentMinute*100 + currentSecond)</code>. The current date
 * is returned as an integer representation (<code>currentYear*10000 +
 * currentMonth*100 + currentDayOfMonth</code>) and a wordy string
 * representation (i.e. using <code>
 * {@link SimpleDateFormat}(&quot;EEE MMM dd hh:mm:ss yyyy&quot;)</code>).
 * <P>
 * Note this system component has no input view.
 */
public class GetCurrentDateTime extends SystemComponent
{
    /** Output view. */
    public GetCurrentDateTimeO out = new GetCurrentDateTimeO();

    protected void clearOutputView() { out.clear(); }


    protected void execute()
    {
        Date today = new Date();
        SimpleDateFormat formatter;

         // Get the current time in the format +0000hhmmss
        formatter = new SimpleDateFormat("hhmmss");
        out.currentTime = Integer.parseInt("0000" + formatter.format(today));
      
        // Get the current date in the format +00ccyymmdd
        formatter = new SimpleDateFormat("yyyyMMdd");    
        out.currentDate = Integer.parseInt("00" + formatter.format(today));
      
        // Get the current date and time in the format day mon dd hh:mm:ss ccyy
        formatter = new SimpleDateFormat("EEE MMM dd hh:mm:ss yyyy");
        out.currDteTmString = formatter.format(today);
    }
}
