package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.view.GetBusinessProcessNameO;

/**
 * This class is supposed to return the currently running process name.
 * However as rebased clients are often launched as rules this
 * information is retrieved through a system property
 * "business.process".
 * <p>
 * As an example the {@link transmute.runtime.Launcher} class correctly
 * sets this property before starting the appropriate rule.
 */
public class GetBusinessProcessName extends SystemComponent
{
    /** Output view. */
    public GetBusinessProcessNameO out = new GetBusinessProcessNameO();

    private String processName;

    public GetBusinessProcessName()
    {
        processName = Config.instance().getString("business.process");
        if (processName == null)
        {
            Log.warning(this,
                "required business.process property not set.");
            processName = "";
        }
    }

    protected void clearOutputView() { out.clear(); }

    protected void execute()
    {
        out.businessProcess = processName;
    }
}
