package com.ibm.ie.reeng.rt.client.applet;

import com.ibm.ie.reeng.rt.common.FilterMarshall;
import com.ibm.ie.reeng.rt.common.Marshall;
import com.ibm.ie.reeng.rt.common.Comms;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;

import java.io.IOException;
import java.io.OutputStream;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/* 
 * This class acts as a wrapper class for HttpComms.  HttpComms "calls" this 
 * class and HttpCommsServlet in turns call the comms class specified in 
 * the runtime.properties ("server.comms").
 */

public final class HttpCommsServlet extends HttpServlet {

    private static Comms comms;
    private Marshall marshall;
    private String ruleName = new String();


    public void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
    {
        OutputStream out;
        InputStream in;
        String requestString = new String();
        String responseString;
        String strBuffer;
        int count = 0;
        byte buffer[] = new byte[50];

        ruleName = request.getQueryString();
        Log.information(this,"Rulename = " + ruleName);
        
        response.setContentType("binary");
//      response.setContentType("text/html");
        try {
            in = request.getInputStream();
            while ((count = in.read(buffer)) > 0) {
                strBuffer = new String(buffer,0, count);
                requestString += strBuffer;
                // Report how many bytes read
                //Log.information(this,"Read " + count + " bytes.");
                //Log.information(this,"buffer :" + strBuffer);
            }
            Log.information(this,"Data received from client:" + requestString);
            in.close();


            // Call the comms class here
            responseString = callComms(requestString);
            Log.information(this,"Data sent to client:" + responseString);

            out = response.getOutputStream();
            out.write(responseString.getBytes());
            out.close();
        } 
        catch( IOException e ) 
        {  
            Log.exception(e);
        }
    }




    private String callComms(String requestString)
    {

        newMarshall();

        marshall.writeChar(requestString,requestString.length());

        getComms().send(ruleName, marshall);

        return marshall.readChar(marshall.getLength());
        
    }



    private Comms getComms()
    {
        if (comms != null)
            return comms;

        String name = Config.instance().getString("server.comms");
        Log.information(this,"Property for server.comms = " + name);
        if (name == null)
            Log.fatalError(this,
                "\"comms\" system property is not set. ");

        if (name.equals("transmute.runtime.HttpComms"))
            Log.fatalError(this,
                "transmute.runtime.HttpComms should not instantiate itself - please correct runtime.properties");
        try
        {
            comms = (Comms)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException e)
        {
            Log.fatalError(this, "cannot load Comms class " + name);
        }
        catch (Exception e)
        {
            Log.fatalError(this,
                "error creating instance of Comms class " + name);
        }

        return comms;
    }


    private void newMarshall()
    {
        String name = Config.instance().getString("server.marshall");

        if (name == null)
            Log.fatalError(this,
                "\"marshall\" system property is not set. ");

        try
        {
            marshall = (Marshall)Class.forName(name).newInstance();

            marshall = new FilterMarshall(marshall);
        }
        catch (ClassNotFoundException e)
        {
            Log.fatalError(this, "cannot load Marshall class "
                + name);
        }
        catch (Exception e)
        {
            Log.fatalError(this,
                "error creating instance of Marshall class " + name);
        }
    }


    protected Marshall getMarshall() { return marshall; }


}
