package com.ibm.ie.reeng.rt.client.applet;

import com.ibm.ie.reeng.rt.common.Config;

import java.util.HashMap;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.io.InputStream;
import java.io.IOException;
import javax.swing.JApplet;


/**
 * This class is responsible for loading the properties for a rebased
 * applet client. It reads them from the "runtime.properties" resource
 * bundle.
 * After reading this resource, it checks for the existance of the
 * "properties.files" property. This is treated as a comma separated
 * list of property resource names sans the .properties suffix.
 * <p>
 * Note 
 */
public class ConfigSource implements Config.Source
{
    private static String PROPERTIES_RESOURCE_NAME = "runtime";

    private HashMap properties = new HashMap();

    private JApplet applet;

    ConfigSource(JApplet a)
    {
        applet = a;

        loadProperties(PROPERTIES_RESOURCE_NAME);
        
        String otherFiles = getString("properties.files");
        if (otherFiles != null)
        {
            StringTokenizer toks = new StringTokenizer(otherFiles, ",");
            while (toks.hasMoreTokens())
            {
                loadProperties(toks.nextToken().trim());
            }
        }
    }

    private void loadProperties(String resourceName)
    {
        try
        {
            ResourceBundle bundle = ResourceBundle.getBundle(resourceName);

            Enumeration e = bundle.getKeys();
            while (e.hasMoreElements())
            {
                String key = (String)e.nextElement();
                properties.put(key, bundle.getString(key));
            }
            System.out.println(resourceName + " loaded");
        }
        catch (Exception e)
        {
            System.out.println("Warning: couldn't find resource bundle "
                + resourceName);
        }
    }

    public String getString(String key)
    {
        String v = applet.getParameter(key);

        if (v != null) return v;

        return (String)properties.get(key);
    }

    public boolean getBoolean(String key)
    {
        String s = getString(key);
        return s != null && Boolean.valueOf(s).booleanValue();
    }

    public Integer getInteger(String key)
    {
        try { return Integer.valueOf(getString(key)); }
        catch (NumberFormatException e)
        {
            return null;
        }
    }

    public int getInt(String key)
    {
        Integer i = getInteger(key);

        if (i != null) return i.intValue();

        System.out.println("required property " + key + " not set");

        return -1;
    }
}
