package com.ibm.ie.reeng.rt.client;

import javax.swing.UIManager;
import javax.swing.JTextArea;
import java.awt.Color;
import javax.swing.text.Document;
import java.awt.event.KeyEvent;
import java.awt.event.InputMethodEvent;

/**
 * This class is an extension to {@link JTextArea} which incorporates 
 * a workaround for a JDK bug (see {@link JTextFieldBugFix} for
 * details).
 */
public class TransmuteTextArea extends JTextArea
    implements Identifier, DataHandler.Interface, TextDataHandler.Interface,
               java.io.Serializable

{
    private TextDataHandler handler = new TextDataHandler(this);


    public TransmuteTextArea() { setDisabledTextColor(getForeground()); }


    public void setClientData(ClientData clientData)
    {
        handler.setClientData(clientData);
    }


    public DataHandler getDataHandler() { return handler; }


    // ------------------------------------------------------------------------


    public boolean isFocusTraversable()
    {
        return (isEditable() ? super.isFocusTraversable() : false);
    }


    public Color getBackground()
    {
        Color background = super.getBackground();

        if (background == null) return null;

        // If it's been set to something special...
        if (!background.equals(UIManager.getColor("TextArea.background")))
            return background;

        return isEditable() && isEnabled() ?
            super.getBackground() : UIManager.getColor("Panel.background");
    }

    public void setMandatory(boolean mandatory)
    {
        getDataHandler().setMandatory(mandatory);
    }

    public boolean getMandatory()
    {
        return getDataHandler().getMandatory();
    }

    public void setImmediateReturn(boolean immediateReturn)
    {
        getDataHandler().setImmediateReturn(immediateReturn);
    }

    public boolean getImmediateReturn()
    {
        return getDataHandler().getImmediateReturn();
    }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }


    // ------------------------------------------------------------------------


    private boolean altPressed = false;


    protected void processComponentKeyEvent(KeyEvent event)
    {
        super.processComponentKeyEvent(event);
        altPressed = event.isAltDown();
    }


    protected void processInputMethodEvent(InputMethodEvent e)
    {
        if (altPressed) e.consume();
        super.processInputMethodEvent(e);
    }
}
