package com.ibm.ie.reeng.rt.client;

import javax.swing.JRadioButton;

/**
 * A simple extension to {@link JRadioButton} to provide Hps radio
 * buttons.
 */
public class TransmuteRadioButton extends JRadioButton
    implements Identifier, DataHandler.Interface, java.io.Serializable
{
    RadioButtonDataHandler handler = new RadioButtonDataHandler(this);


    public DataHandler getDataHandler() { return handler; }


    public TransmuteRadioButton() { super(); }
    public TransmuteRadioButton(String text) { super(text); }


    public void setClientData(ClientData clientData)
    {
        handler.setClientData(clientData);
    }

    public void setMandatory(boolean mandatory)
    {
        getDataHandler().setMandatory(mandatory);
    }

    public boolean getMandatory()
    {
        return getDataHandler().getMandatory();
    }

    public void setImmediateReturn(boolean immediateReturn)
    {
        getDataHandler().setImmediateReturn(immediateReturn);
    }

    public boolean getImmediateReturn()
    {
        return getDataHandler().getImmediateReturn();
    }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }
}
