package com.ibm.ie.reeng.rt.client;

import javax.swing.JList;
import javax.swing.AbstractListModel;
import java.awt.SystemColor;


/**
 * A {@link JList} extension to emulate Hps lists. While such lists have
 * many similarities with single column tables, there are enough
 * differences to make attempting to share code uneconomic.
 */
public class TransmuteList extends JList
    implements Identifier, DataHandler.Interface, java.io.Serializable
{
    private ListDataHandler handler = new ListDataHandler(this);
    private DataModel model = new DataModel();


    public DataHandler getDataHandler() { return handler; }


    // ------------------------------------------------------------------------


    private ClientData clientData;


    public void setClientData(ClientData clientData)
    {
        this.clientData = clientData;

        setModel(model);

        handler.setClientData(clientData);
    }


    // ------------------------------------------------------------------------


    /**
     * Note: this and the DataModel in TransmuteComboBox are similar.
     * Perhaps this commonality should be factored out.
     */
    public class DataModel extends AbstractListModel
    {
        public int getSize()
        {
            if (clientData == null) return 0;
            else return clientData.getSize();
        }


        public Object getElementAt(int i)
        {
            return clientData.getString(i);
        }


        public void fireContentsChanged()
        {
            fireContentsChanged(this, 0, (getSize() - 1));
        }
    }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }

    public void setMandatory(boolean mandatory)
    {
        getDataHandler().setMandatory(mandatory);
    }

    public boolean getMandatory()
    {
        return getDataHandler().getMandatory();
    }

    public void setImmediateReturn(boolean immediateReturn)
    {
        getDataHandler().setImmediateReturn(immediateReturn);
    }

    public boolean getImmediateReturn()
    {
        return getDataHandler().getImmediateReturn();
    }


    // ------------------------------------------------------------------------


    public void requestFocus(int row)
    {
        requestFocus();

        if (row >= getModel().getSize()) return;

        ensureIndexIsVisible(row);

        setSelectedIndex(row);
    }
}
