package com.ibm.ie.reeng.rt.client;

import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import java.awt.Color;


/**
 * A simple extension to {@link JTextArea} for Hps labels. We cannot use
 * {@link javax.swing.JLabel} because the Hps label wraps text on word
 * boundaries.
 */
public class TransmuteLabel extends JTextArea implements Identifier, java.io.Serializable
{
    public TransmuteLabel() { super(); }
    public TransmuteLabel(String text) { super(text);}

    public void updateUI()
    {
        super.updateUI();

        setLineWrap(true);
        setWrapStyleWord(true);
        setEditable(false);
        setHighlighter(null);
        setOpaque(false);

        setEnabled(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background",
            "Label.foreground", "Label.font");
    }

    public void setForeground(Color c) { setDisabledTextColor(c); }

    // ------------------------------------------------------------------------
   
    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }
}
