package com.ibm.ie.reeng.rt.client;

//import javax.swing.*;
import javax.swing.JPanel;
import javax.swing.BorderFactory;

import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import java.awt.Color;
import java.awt.Font;

/**
 * A simple extension to {@link JPanel} to provide etched borders.
 */
public class TransmuteGroupBox extends JPanel implements Identifier, java.io.Serializable
{
    private javax.swing.border.Border border;

    /** Creates a group box with no title.  */
    public TransmuteGroupBox() { this(null); }

    public void setText(String text)
    {
        border = BorderFactory.createEtchedBorder();

        if (text != null)
            border = BorderFactory.createTitledBorder(border, text);

        setBorder(border);
        setOpaque(false);

        this.text=text;
    }

    public String getText()
    {
        return text;
    }

    public TransmuteGroupBox(String text)
    {
        super(null);
    
        setText(text);
    }

    public void setTitleFont(Font f)
    {
        if (border instanceof TitledBorder)
            ((TitledBorder)border).setTitleFont(f);
    }

	public void setTitleColor(Color color)
	{
        if (border instanceof TitledBorder)
            ((TitledBorder)border).setTitleColor(color);		
	}


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }

    private String text;
}
