package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.HpsEventType;
import com.ibm.ie.reeng.rt.common.HpsEventView;
import com.ibm.ie.reeng.rt.common.Location;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Util;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.LayoutManager;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Frame;
import java.awt.Color;

import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.util.Stack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.NoSuchElementException;


import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.JScrollPane;
import javax.swing.Icon;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.JButton;
import javax.swing.ButtonModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.ImageIcon;

import javax.swing.text.DefaultEditorKit;
import java.net.URL;

/**
 * This is the base class for all generated windows. It simulates the
 * Hps synchronous model of user interaction by using a custom event
 * queue (see {@link #postWakeupEvent} and {@link #processWakeupEvents}
 * for example).
 * <p>
 */
public class TransmuteDialog extends JFrame
    implements ActionListener, Identifier, java.io.Serializable
{
    protected Unknown unknown;

    protected TransmuteLabel label;
    protected TransmuteBitmap bitmap;
    protected TransmuteButton button;
    protected TransmuteHotspot hotspot;
    protected TransmuteRadioButton radioButton;
    protected TransmuteCheckBox checkBox;
    protected TransmuteTextField textField;
    protected TransmuteTextArea textArea;
    protected TransmuteComboBox comboBox;
    protected TransmuteGroupBox groupBox;
    protected TransmuteTable table;
    protected TransmuteList list;
    protected JPanel rectangle;

    protected TransmuteTableModel model;
    protected TransmuteColumn column;

    protected JMenuBar menuBar;
    protected JMenu menu;
    protected TransmuteMenuItem menuItem;
    protected JSeparator separator;

    protected Stack menuStack;

    protected JScrollPane scrollPane;

    private transient Thread instantiatingThread;
    static private final HashMap threadDataMap=new HashMap();

    private static class ThreadData
    {
        ThreadData()
        {
            windowStack=new Stack();
            deferredList=new ArrayList();
        }
        
        TransmuteDialog current;
        Stack windowStack;
        ArrayList deferredList;
        
    }
    
    /** Record the thread-specific data.
      * This is so that we have access to it later when we 
      * are called later from the Swing thread.
      * Note: This data used to be static.
      */
    private void recordThreadData()
    {
        instantiatingThread=Thread.currentThread();

        ThreadData threadData=(ThreadData)threadDataMap.get(instantiatingThread);

        if (threadData==null)
        {
            // It's a new thread - Record it
            threadDataMap.put(instantiatingThread, new ThreadData());
        }
    }
   
    private static ThreadData getThreadData(Thread t)
    {
        ThreadData threadData=(ThreadData)threadDataMap.get(t);

        if (threadData==null)
        {
            Log.fatalError(null, "No ThreadData found");
            return null;
        }

        return threadData;
    }
    
    /* current, windowStack and deferredList used to be statics.  
     * There are now one of each associated with each instantiating
     * thread to support the USE RULE ... DETACH case */
    
    // private static TransmuteDialog current
    private TransmuteDialog getCurrent()
    {
        return getThreadData(instantiatingThread).current;
    }

    private void setCurrent(TransmuteDialog current)
    {
        getThreadData(instantiatingThread).current=current;
    }
    
    //private static Stack windowStack = new Stack();
    private Stack getWindowStack()
    {
        return getThreadData(instantiatingThread).windowStack;
    }

    //private static ArrayList deferredList = new ArrayList();
    private ArrayList getDeferredList()
    {
        return getThreadData(instantiatingThread).deferredList;
    }
    
    private void setDeferredList(ArrayList al)
    {
        getThreadData(instantiatingThread).deferredList=al;
    }
    
    private Cursor normalCursor;

    private HpsEventView hpsEventView;


    protected ClientData clientData;

    protected Rule.UseMode useMode=Rule.UseMode.NORMAL;

    public void setUseMode(Rule.UseMode useMode)
    {
        this.useMode=useMode;
    }

    public synchronized void notifyEvent()
    {
        notify();
    }


    /** For windows which don't use a HpsEventView. */
    public TransmuteDialog() { this(null); }

    public TransmuteDialog(HpsEventView hpsEventView)
    {
        recordThreadData();
        
        this.hpsEventView
            = hpsEventView == null ? new HpsEventView()
            : hpsEventView;

        setResizable(false);

        // The application controls windows closing.
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

        setupModal();
        setupBlocking();

        // Add listener for help key.
        addKeyListener(new HelpKeyListener());
    }


    /**
     * If a window has a view child it should implement this method
     * so that it can be used to clear that view.
     */
    public void clearView() { }


    public void dispose()
    {
        javax.swing.SwingUtilities.invokeLater(new Runnable()
            {
                public void run()
                {
                    TransmuteDialog.super.dispose();
                }
            });
    }


    // ------------------------------------------------------------------------

    private ConverseLock lock = new ConverseLock();

    /**
     * Calling rule records just that - the calling rule.
     * It is used for event processing where events may
     * get sent to the rule.  We need to pick them up in
     * the converse.
     */
    private Rule callingRule;

    public void setCallingRule(Rule rule)
    {
        callingRule=rule;
    }

    void waitForConverse() { lock.waitForConverse(); }

    boolean isInConverse() { return lock.isInConverse(); }

    public String converse() { return converse(false); }


    private class ConverseWork implements Runnable
    {
        ConverseWork(boolean nowait)
        {
            this.nowait=nowait;
        }

        public void run()
        {
            useDeferred();
            displayData();

            open();
            setVisible(true);

            if (!nowait)
            {
                wakeup = processWakeupEvents(discard);
                if (!wakeup)
                    setBusy(false);
/*
                if (!wakeup)
                {
                    setBusy(false);

                    while (!wakeup)
                    {
                        try
                        {
                            synchronized(this)
                            {
                                wait();
                            }
                        }
                        catch (InterruptedException e)
                        {
                            Log.exception(e);
                        }

                        wakeup = processWakeupEvents(false);
                    }

                    setBusy(true);
                }
*/
                // Log the event that ended converse.
                hpsEventView.dump();
            }
            
            discard=false;

            // result=hpsEventView.getWindowRetcode();
        }

        private boolean discard=true;
        private boolean nowait;
        private boolean wakeup=false;
        
        public boolean wakeup()
        {
            return wakeup;
        }
    }
    
    /**
     * The calling thread is blocked.
     */
    public String converse(boolean nowait)
    {
        lock.setInConverse(true);

        Log.information(this, "entering converse()");

        // Don't know what priority global events should get
        // Try here..
        
        if (!processUserEvent())
        {
            ConverseWork converseWork=new ConverseWork(nowait);

            while (nowait || !converseWork.wakeup())
            {
                try
                {
                    javax.swing.SwingUtilities.invokeAndWait(converseWork);
                }
                catch (InterruptedException e)
                {
    //                Log.fatalError(this, "InterruptedException thrown while executing converse");
                    Log.error(this, "InterruptedException thrown while executing converse");
                    return null;

                }
                catch (java.lang.reflect.InvocationTargetException e)
                {
                    e.printStackTrace();
                    Log.fatalError(this, "InvocationTargetException thrown while executing converse: "+e.toString());
                }

                if (nowait)
                    break;
                else
                {
                    try
                    {
                        if (!converseWork.wakeup())
                        {
                            synchronized(this)
                            {
                                if (callingRule!=null)
                                    callingRule.setConversingWindow(this);
                                wait();
                                if (callingRule!=null)
                                    callingRule.setConversingWindow(null);
                                if (processUserEvent())
                                    break;
                            }
                        }
                    }
                    catch (InterruptedException e)
                    {
                        Log.exception(e);
                        return null;
                    }
                }
            }
        }


        Log.information(this, "exiting converse().");

        lock.setInConverse(false);

        return hpsEventView.getWindowRetcode();
    }

    private boolean processUserEvent()
    {
        if (callingRule!=null && callingRule.hasEvent())
        {
            Rule.Event event=callingRule.getEvent();

            hpsEventView.clear();
            hpsEventView.eventType=HpsEventType.USER_EVENT;
            hpsEventView.eventName=event.getEventName();
            hpsEventView.eventSource=event.getEventSource();
            hpsEventView.eventQualifier="";   // Currently not supported
            hpsEventView.eventView=event.getEventView();
            hpsEventView.eventParam=event.getEventParam();
            return true;
        }

        return false;
    }
        

    public synchronized void actionPerformed(ActionEvent e)
    {
        Object source = e.getSource();

        WakeupEvent wakeupEvent =
            new WakeupEvent(HpsEventType.INTERFACE_EVENT);

        String name = null;

        if (source instanceof TransmuteButton) name = "HPS_PB_CLICK";
        else if (source instanceof TransmuteMenuItem) name = "HPS_MENU_SELECT";
        else if (source instanceof TransmuteHotspot) name = "HPS_HS_CLICK";
        else Log.fatalError(this, "source of unexpected class " +
            source.getClass().getName());

        wakeupEvent.setEventName(name);
        wakeupEvent.setEventSource(getIdentifier(source));

        Checking checking = ((Checking.Interface)source).checking();

        if (checking.checkMandatory()) wakeupEvent.setCheckMandatory();
        if (checking.ignoreValidation()) wakeupEvent.setIgnoreValidation();

        postWakeupEvent(wakeupEvent);
    }


    // ------------------------------------------------------------------------


    private String windowLongName;


    protected void setLongName(String name) { windowLongName = name; }


    public String getLongName() { return windowLongName; }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }


    // ------------------------------------------------------------------------

    private String defaultHelpTopic = null;


    public void setHelpTopic(String defaultTopic)
    {
        this.defaultHelpTopic = defaultTopic;
    }

    /**
     * Used by Help menu items.
     */
    protected ActionListener getHelpActionListener()
    {
        return new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                Help.showHelpTopic(defaultHelpTopic);
            }
        };
    }

    private class HelpKeyListener extends KeyAdapter
    {
        public void keyPressed(KeyEvent event)
        {
            if (event.getKeyCode() == KeyEvent.VK_F1)
            {
                if (defaultHelpTopic != null)
                    Help.showHelpTopic(defaultHelpTopic);
                else
                {
                    String identifier = findIdentifier();
                    Help.showHelpTopic(identifier);
                }
            }
        }


        private String findIdentifier()
        {
            java.awt.Component focusOwner = getFocusOwner();

            if (focusOwner == null) return getIdentifier();

            java.awt.Component component = findIdentifierComponent(focusOwner);

            if (component == null) return getIdentifier();

            return getIdentifier(component);
        }
    }


    private java.awt.Component findIdentifierComponent(java.awt.Component component)
    {
        if (component instanceof Identifier) return component;

        // Try searching down first...

        if (component instanceof Container)
        {
            java.awt.Component[] children = ((Container)component).getComponents();

            for (int i = 0; i < children.length; i++)
            {
                java.awt.Component child = children[i];
                java.awt.Component result;

                if ((result = findIdentifierComponent(child)) != null)
                    return result;
            }
        }

        // If that doesn't work try searching up...

        while (component != null && !(component instanceof Identifier))
            component = component.getParent();

        return component;
    }


    private String getIdentifier(Object o)
    {
        return ((Identifier)o).getIdentifier();
    }


    // ------------------------------------------------------------------------


    private static class WakeupEvent
    {
        private int type;
        private String name = "";
        private String source = "";
        private String qualifier = "";
        private String view = "";
        private String param = "";

        private boolean checkMandatory = false;
        private boolean ignoreValidation = false;

        private boolean ignoreStoreResult = false;

        private boolean discardable = true;

        public String toString()
        {
            return  "type="+type+", "+
                    "name="+name+", "+
                    "source="+source+", "+
                    "qualifier="+qualifier+", "+
                    "view="+view+", "+
                    "param="+param+", "+
                    "checkMandatory="+checkMandatory+", "+
                    "ignoreValidation="+ignoreValidation+", "+
                    "ignoreStoreResult="+ignoreStoreResult+", "+
                    "discardable="+discardable;
        }


        public WakeupEvent(int type) { this.type = type; }


        public void setEventName(String name) { this.name = name; }


        public void setEventSource(String source) { this.source = source; }


        public void setEventQualifier(String qualifier)
        {
            this.qualifier = qualifier;
        }


        public void setEventView(String view) { this.view = view; }


        public void setEventParam(String param) { this.param = param; }


        public void setCheckMandatory() { checkMandatory = true; }


        public void setIgnoreValidation() { ignoreValidation = true; }


        public void setIgnoreStoreResult() { ignoreStoreResult = true; }


        public void unsetDiscardable() { discardable = false; }


        public boolean getDiscardable() { return discardable; }


        public String getName() { return name; }


        public boolean construct(TransmuteDialog parent)
        {
            boolean result =
                parent.storeData(checkMandatory, ignoreValidation);

            if (!result && !ignoreStoreResult) return false;
            parent.hpsEventView.clear();
            parent.hpsEventView.eventType = type;
            parent.hpsEventView.eventName = name;
            parent.hpsEventView.eventSource = source;
            parent.hpsEventView.eventQualifier = qualifier;
            parent.hpsEventView.eventView = view;
            parent.hpsEventView.eventParam = param;

            return true;
        }
    }


    private LinkedList wakeupEventQueue = new LinkedList();


    private synchronized void postWakeupEvent(WakeupEvent wakeupEvent)
    {
        wakeupEventQueue.add(wakeupEvent);

        notify();
    }


    private boolean processWakeupEvents(boolean discard)
    {
        // First clean up the queue.

        HashSet coalese = new HashSet();
        int end = wakeupEventQueue.size() - 1;

        for (int i = end; i >= 0; i--)
        {
            WakeupEvent wakeupEvent =
                (WakeupEvent)wakeupEventQueue.get(i);

            if (discard && wakeupEvent.getDiscardable())
                wakeupEventQueue.remove(i);
            else
            {
                String name = wakeupEvent.getName();

                // Discard events that have been superseded.
                if (coalese.contains(name)) wakeupEventQueue.remove(i);
                else coalese.add(name);
            }
        }

        if (wakeupEventQueue.isEmpty()) return false;

        // Now process an event.

        WakeupEvent wakeupEvent =
            (WakeupEvent)wakeupEventQueue.removeFirst();


        boolean result = wakeupEvent.construct(this);

        // This should never happen...
        if (!result && !wakeupEventQueue.isEmpty())
        {
            Log.error(this,
                "one or more events are stuck in the wakeup event queue");

            // Throw away the stuck events.
            while (!wakeupEventQueue.isEmpty()) wakeupEventQueue.removeFirst();
        }

        return result;
    }


    // ------------------------------------------------------------------------


    /**
     * Registers our custom default action code.
     */
    protected void setEnterAction(String identifier)
    {
        getRootPane().registerKeyboardAction(
            new EnterAction(true, identifier, this),
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false),
            JComponent.WHEN_IN_FOCUSED_WINDOW);
        getRootPane().registerKeyboardAction(
            new EnterAction(false, identifier, this),
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, true),
            JComponent.WHEN_IN_FOCUSED_WINDOW);
    }


    private static class EnterAction extends AbstractAction
    {
        private TransmuteDialog parent;
        private String identifier;
        private boolean press;


        public EnterAction(boolean press, String identifier,
            TransmuteDialog parent)
        {
            this.press = press;
            this.identifier = identifier;
            this.parent = parent;
        }

        /**
         * Note since focus isn't transferred when the default button is
         * activated, we need to force data validation here.
         */
        public void actionPerformed(ActionEvent e)
        {
            java.awt.Component child = parent.findChildByIdentifier(identifier);


            if (!parent.storeData(true, false)) return;

            parent.displayData();

            if (child != null && child instanceof JButton)
            {
                JButton button = (JButton)child;
                ButtonModel model = button.getModel();

                if (press)
                {
                    model.setArmed(true);
                    model.setPressed(true);
                }
                else model.setPressed(false);
            }
            else if (press)
            {
                parent.postWakeupEvent(createEnterWakeupEvent(identifier));
            }
        }


        private WakeupEvent createEnterWakeupEvent(String identifier)
        {
            WakeupEvent wakeupEvent =
                new WakeupEvent(HpsEventType.INTERFACE_EVENT);

            wakeupEvent.setEventName("HPS_WIN_ENTER");
            wakeupEvent.setEventSource(identifier);
            wakeupEvent.setCheckMandatory();

            return wakeupEvent;
        }
    }


    // ------------------------------------------------------------------------


    protected void setCloseAction(final String identifier)
    {
        addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e)
            {
                postWakeupEvent(createCloseWakeupEvent(identifier));
            }
        });
    }


    private WakeupEvent createCloseWakeupEvent(String identifier)
    {
        WakeupEvent wakeupEvent =
            new WakeupEvent(HpsEventType.INTERFACE_EVENT);

        wakeupEvent.setEventName("HPS_WIN_CLOSE");
        wakeupEvent.setEventSource(identifier);
        wakeupEvent.setIgnoreValidation();
        wakeupEvent.setIgnoreStoreResult();

        return wakeupEvent;
    }


    // ------------------------------------------------------------------------
        

    public void dispatchImmediateReturnEvent(String hpsId)
    {
        postWakeupEvent(createImmediateReturnWakeupEvent(hpsId));
    }


    private WakeupEvent createImmediateReturnWakeupEvent(String identifier)
    {
        WakeupEvent wakeupEvent =
            new WakeupEvent(HpsEventType.INTERFACE_EVENT);

        wakeupEvent.setEventName("HPS_IMMEDIATE_RETURN");
        wakeupEvent.setEventSource(identifier);
        wakeupEvent.setIgnoreValidation();
        wakeupEvent.setIgnoreStoreResult();

        return wakeupEvent;
    }


    // ------------------------------------------------------------------------


    public static String TABLE_EVENT_INIT = "INIT";
    public static String TABLE_EVENT_UP = "UP";
    public static String TABLE_EVENT_DOWN = "DOWN";


    public void dispatchTableOutRangeEvent(TransmuteTable source,
        String qualifier)
    {
        String identifier = source.getIdentifier();
        int elevatorPos = source.getFirstVisibleRowVirtualOccurrence();

        postWakeupEvent(createTableOutRangeWakeupEvent(identifier,
            elevatorPos, qualifier));
    }


    private WakeupEvent createTableOutRangeWakeupEvent(
        String identifier, int elevatorPos, String qualifier)
    {
        WakeupEvent wakeupEvent =
            new WakeupEvent(HpsEventType.INTERFACE_EVENT);

        wakeupEvent.setEventName("HPS_LB_OUTRANGE");
        wakeupEvent.setEventSource(identifier);
        // Add 1 to elevatorPos as HPS indexes from 1.
        wakeupEvent.setEventParam(Integer.toString(elevatorPos + 1));
        wakeupEvent.setEventQualifier(qualifier);
        wakeupEvent.unsetDiscardable();

        return wakeupEvent;
    }


    // ------------------------------------------------------------------------


    public final static String TABLE_EVENT_TOP = "HPS_LB_TOP";
    public final static String TABLE_EVENT_BOTTOM = "HPS_LB_BOTTOM";


    public void dispatchTableAutoCallEvent(TransmuteTable source, String name)
    {
        String identifier = source.getIdentifier();
        int elevatorPos = source.getFirstVisibleRowVirtualOccurrence();

        postWakeupEvent(
            createTableAutoCallWakeupEvent(identifier, elevatorPos, name));
    }


    private WakeupEvent createTableAutoCallWakeupEvent(
        String identifier, int elevatorPos, String name)
    {
        WakeupEvent wakeupEvent =
            new WakeupEvent(HpsEventType.INTERFACE_EVENT);

        wakeupEvent.setEventName(name);
        wakeupEvent.setEventSource(identifier);
        // Add 1 to elevatorPos as HPS indexes from 1.
        wakeupEvent.setEventParam(Integer.toString(elevatorPos + 1));
        wakeupEvent.unsetDiscardable();

        return wakeupEvent;
    }


    // ------------------------------------------------------------------------


    public static TransmuteDialog getParentDialog(java.awt.Component child)
    {
        java.awt.Component parent = child;

        while (parent != null)
        {
            if (parent instanceof TransmuteDialog) return
                (TransmuteDialog)parent;

            parent = parent.getParent();
        }

        return null;
    }


    // ------------------------------------------------------------------------


    /**
     * Note: this method should be private, it has been made public for
     * use in demos. It should otherwise be treated as private.
     */
    public void setBusy(final boolean busy)
    {
        getGlassPane().setVisible(busy);

        if (busy && normalCursor==null)
        {
            normalCursor = getCursor();
            setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        }
        else
        {
            if (normalCursor != null) setCursor(normalCursor);
            normalCursor=null;
        }
    }


    private void setupBlocking()
    {
        JPanel glass = (JPanel)getGlassPane();
        glass.setOpaque(false);
        glass.addMouseListener(new BlockingMouseListener());
        glass.addKeyListener(new BlockingKeyListener());

        setBusy(true);
    }


    private class BlockingMouseListener extends MouseAdapter
    {
        public void mousePressed(MouseEvent e)
        {
            e.consume();

            if (e.getComponent().isVisible())
                Toolkit.getDefaultToolkit().beep();
        }
    }


    private class BlockingKeyListener extends KeyAdapter
    {
        public void keyPressed(KeyEvent e)
        {
            e.consume();

            // Don't beep if user is just pressing the ALT key.
            if (e.getKeyCode() != KeyEvent.VK_ALT)
                Toolkit.getDefaultToolkit().beep();
        }
    }


    // ------------------------------------------------------------------------


    private void setupModal()
    {
        addWindowListener(new ModalWindowListener(this));
    }

        
    private class ModalWindowListener extends WindowAdapter
    {
        private TransmuteDialog parent;


        public ModalWindowListener(TransmuteDialog parent)
        {
            this.parent = parent;
        }


        public void windowActivated(WindowEvent e)
        {
            if (parent != getCurrent() && getCurrent() != null)
            {
                Toolkit.getDefaultToolkit().beep();
                getCurrent().toFront();
            }
        }

        public void windowIconified(WindowEvent e)
        {
            setStates(Frame.ICONIFIED);
        }

        public void windowDeiconified(WindowEvent e)
        {
            setStates(Frame.NORMAL);
        }

        private void setStates(int state)
        {
            TransmuteDialog[] dialogs = getDialogs();

            for (int i = 0; i < dialogs.length; i++)
                dialogs[i].setState(state);
        }
    }


    public void open()
    {
        // Disable the previous window
        if (getCurrent()!=null)
        {
            getCurrent().setBusy(true);
            
            // Also, hide the current one, if appropriate
            if (useMode!=Rule.UseMode.NEST)
                getCurrent().setVisible(false);
        }
                
        int count=getWindowStack().size();
        for (int i = 0; i < count; i++)
        {
            TransmuteDialog dialog = (TransmuteDialog)getWindowStack().get(i);

            if (dialog!=getCurrent())
                dialog.setBusy(true);
        }
        setCurrent(this);
        
        Log.information(this, "this window is now the current window");

        getWindowStack().removeElement(getCurrent());
        getWindowStack().push(getCurrent());


        setVisible(true);
        setBusy(false);
    }
   
    public void close()
    {
        setVisible(false);
        getWindowStack().removeElement(this);
        setCurrent(getWindowStack().empty() ?
            null : (TransmuteDialog)getWindowStack().peek());

        if (getCurrent() != null)
        {
            Log.information(this, getCurrent().getClass().getName() +
                " is now the current window");
        }
        else
        {
            Log.information(this, "nothing is now the current window");
        }
    }

    /*
    public void setVisible(boolean visible)
    {
        if (visible)
        {
            current = this;

            Log.information(this, "this window is now the current window");

            windowStack.removeElement(current);
            windowStack.push(current);
        }
        else
        {
            windowStack.removeElement(this);
            current = windowStack.empty() ?
                null : (TransmuteDialog)windowStack.peek();

            if (current != null)
            {
                Log.information(this, current.getClass().getName() +
                    " is now the current window");
            }
            else
            {
                Log.information(this, "nothing is now the current window");
            }
        }

        super.setVisible(visible);
    }
    */
    
    public static TransmuteDialog findWindow(Thread t, String name)
    {
        Stack wS=getThreadData(t).windowStack;
        
        int count = wS.size();

        for (int i = 0; i < count; i++)
        {
            TransmuteDialog dialog = (TransmuteDialog)wS.get(i);

            if (dialog.getLongName().equals(name)) return dialog;
        }

        Log.error("TransmuteDialog", "could not find window " + name);
        Location.logStack();

        return null;
    }


    /**
     * This method will only work when called from a non-Swing thread.
     */
    public static TransmuteDialog getCurrentDialog()
    {
        return getThreadData(Thread.currentThread()).current; 
    }


    /**
     * This method will only work when called from a non-Swing thread.
     */
    public static TransmuteDialog findWindow(String name)
    {
        return findWindow(Thread.currentThread(), name);
    }


    /**
     * This method will only work when called from a non-Swing thread.
     */
    public static TransmuteDialog[] getDialogs()
    {
        Stack wS=getThreadData(Thread.currentThread()).windowStack;
        
        return (TransmuteDialog[])wS.toArray(new TransmuteDialog[0]);
    }


    // ------------------------------------------------------------------------


    public void setContentPaneSize(int width, int height)
    {
        getContentPane().setLayout(new FixedSizeLayout(width, height));
    }


    public void setContentPaneSize(Dimension d)
    {
        setContentPaneSize(d.width, d.height);
    }


    protected void startSubmenu(String text)
    {
        if (menuStack == null) menuStack = new Stack();

        JMenu submenu = new JMenu(text);

        menu.add(submenu);

        menuStack.push(menu);

        menu = submenu;
    }


    protected void endSubmenu()
    {
        menu = (JMenu)menuStack.pop();
    }


    // ------------------------------------------------------------------------


    /**
     * A convenience method for creating a suitable scroll pane for
     * a TransmuteTable.
     */
    protected JScrollPane createScrollPane(TransmuteTable table)
    {
        return new TransmuteTable.ScrollPane(table);
    }


    // ------------------------------------------------------------------------


    //
    // HPS supports a coordinate space where all values are relative to
    // the size of the primary application font. The following functions
    // take values of this kind and return absolute pixel values.
    //


    private final static double DEFAULT_X_MULTIPLIER = 1.8;
    private final static double DEFAULT_Y_MULTIPLIER = 1.7;

    private static double xMultiplier = -1;
    private static double yMultiplier = -1;


    private void setupMultipliers()
    {
        if (xMultiplier != -1) return;

        String string = Config.instance().getString("x.char.multiplier");

        if (string != null) xMultiplier = Double.parseDouble(string);
        else xMultiplier = DEFAULT_X_MULTIPLIER;

        string = Config.instance().getString("y.char.multiplier");

        if (string != null) yMultiplier = Double.parseDouble(string);
        else yMultiplier = DEFAULT_Y_MULTIPLIER;
    }


    protected Rectangle getPixelBounds(int x, int y, int width, int height)
    {
        return new Rectangle(getPixelPoint(x, y),
            getPixelDimension(width, height));
    }


    protected Point getPixelPoint(int x, int y)
    {
        return new Point(getPixelX(x), getPixelY(y));
    }


    protected Dimension getPixelDimension(int width, int height)
    {
        return new Dimension(getPixelWidth(width), getPixelHeight(height));
    }


    protected int getPixelX(int x)
    {
        setupMultipliers();

        return (int)(x * xMultiplier);
    }


    protected int getPixelY(int y)
    {
        setupMultipliers();

        return (int)(y * yMultiplier);
    }


    protected int getPixelWidth(int width)
    {
        return getPixelX(width);
    }


    protected int getPixelHeight(int height)
    {
        return getPixelY(height);
    }


    // ------------------------------------------------------------------------


    /**
     * This method will only work when called from a non-Swing thread.
     */
    public static void addDeferred(DeferredComponent deferred)
    {
        deferred.setInstantiatingThread(Thread.currentThread());
        getThreadData(Thread.currentThread()).deferredList.add(deferred);
    }


    private void useDeferred()
    {
        if (getDeferredList().size() == 0) return;

        for (int i = 0; i < getDeferredList().size(); i++)
        {
            DeferredComponent deferred = (DeferredComponent)getDeferredList().get(i);

            Log.information(this, "using deferred component " +
                deferred.getClass().getName());

            deferred.use(this);
        }

        setDeferredList(new ArrayList());
    }


    public java.awt.Component findChild(String identifier, String view, String field)
    {
        if (identifier == null) identifier = "";
        if (view == null) view = "";
        if (field == null) field = "";

        if (identifier.equals("") && view.equals("") && field.equals(""))
        {
            Log.error(this,
                "findChild() requires at least one non-empty parameter");

            return null;
        }

        if (!identifier.equals("")) return findChildByIdentifier(identifier);
        else return findChildByDatalink(view, field);
    }


    public java.awt.Component findChildByDatalink(String view)
    {
        return findChildByDatalink(view, "");
    }


    /** This version reports an error if the child cannot be found. */
    public java.awt.Component findChildByDatalink(String view, String field)
    {
        return findChildByDatalink(view, field, true);
    }

    public java.awt.Component findChildByDatalink(String view, String field,
        boolean reportError)
    {
        if (view == null) view = "";
        if (field == null) field = "";

        if (view.equals("") && field.equals(""))
        {
            Log.error(this, "both view and field cannot be empty");

            return null;
        }

        Iterator iterator = new ComponentIterator(DataHandler.Interface.class);

        while (iterator.hasNext())
        {
            DataHandler.Interface child =
                (DataHandler.Interface)iterator.next();

            if (child.getDataHandler().matchLongName(view, field))
                return (java.awt.Component)child;
        }

        if (reportError)
        {
            Log.error(this, "could not find child " + view + "." + field);
            Location.logStack();
        }

        return null;
    }


    public java.awt.Component findChildByIdentifier(String match)
    {
        Iterator iterator = new ComponentIterator(Identifier.class);

        while (iterator.hasNext())
        {
            Object child = iterator.next();

            String id = getIdentifier(child);

            if (id != null && id.equals(match)) return (java.awt.Component)child;
        }

        Log.error(this, "could not find child " + match);
        Location.logStack();

        return null;
    }


    public java.awt.Component[] findChildrenByClass(Class cls, boolean reportError)
    {
        ArrayList list = new ArrayList();

        Iterator iterator = new ComponentIterator(cls);

        while (iterator.hasNext()) list.add(iterator.next());

        if (list.isEmpty() && reportError)
        {
            Log.error(this, "could not find children of class " +
                cls.getName());
            Location.logStack();
            return null;
        }
        else return (java.awt.Component[])list.toArray(new java.awt.Component[0]);
    }

    public java.awt.Component[] findChildrenByClass(Class cls)
    {
        return findChildrenByClass(cls, true);
    }


    public TransmuteMenuItem findMenuItemByIdentifier(String match)
    {
        Iterator iterator = new ComponentIterator(TransmuteMenuItem.class);

        while (iterator.hasNext())
        {
            TransmuteMenuItem item = (TransmuteMenuItem)iterator.next();

            String identifier = getIdentifier(item);

            if (identifier.equals(match)) return item;
        }

        Log.error(this, "could not find menu item " + match);
        Location.logStack();

        return null;
    }


    // ------------------------------------------------------------------------


    private java.awt.Component[] componentArray;


    /*
     * This method initializes componentArray such that in contains
     * all components in and including this window. This includes all
     * descendants not just the windows immediate children.
     */
    private void initializeComponentArray(Container c)
    {
        if (componentArray == null)
        {
            ArrayList componentList = new ArrayList();

            componentList.add(c);

            LinkedList containerQueue = new LinkedList();

            containerQueue.add(c);

            while (!containerQueue.isEmpty())
            {
                Container container = (Container)containerQueue.removeFirst();

                java.awt.Component[] children = container.getComponents();

                for (int i = 0; i < children.length; i++)
                {
                    java.awt.Component child = children[i];

                    componentList.add(child);

                    if (child instanceof JMenu)
                        child = ((JMenu)child).getPopupMenu();

                    if (child instanceof Container)
                    {
                        containerQueue.add(child);
                    }
                }
            }

            componentArray =
                (java.awt.Component[])componentList.toArray(new java.awt.Component[0]);
        }
    }


    private class ComponentIterator implements Iterator
    {
        private Class match;
        private int current = -1;


        public ComponentIterator(Class match)
        {
if (componentArray == null)
    throw new RuntimeException("initializeComponentArray() - Called from unexpected location");
//JP            initializeComponentArray();
            this.match = match;
            setCurrent();
        }


        private void setCurrent()
        {
            while (++current < componentArray.length)
            {
                if (match.isInstance(componentArray[current])) return;
            }

            current = -1;
        }


        public boolean hasNext() { return current != -1; }


        public Object next()
        {
            if (current == -1) throw new NoSuchElementException();

            java.awt.Component result = componentArray[current];

            setCurrent();

            return result;
        }


        public void remove() { throw new UnsupportedOperationException(); }
    }


    // ------------------------------------------------------------------------


    private HashMap sharedDatalinks;


    public void updateSharedDatalinks(DataHandler dataHandler)
    {
        if (sharedDatalinks == null)
        {
            sharedDatalinks = new HashMap();

            Iterator iterator = new ComponentIterator(
                DataHandler.Interface.class);

            while (iterator.hasNext())
            {
                DataHandler.Interface child =
                    (DataHandler.Interface)iterator.next();

                String name = child.getDataHandler().getPrimaryName();
                // May not have a long name (e.g. non-editable text
                // fields).
                if (name != null)
                {
                    ArrayList list = (ArrayList)sharedDatalinks.get(name);

                    if (list == null)
                    {
                        list = new ArrayList();
                        sharedDatalinks.put(name, list);
                    }

                    list.add(child);
                }
            }
        }

        String name = dataHandler.getPrimaryName();
        ArrayList list = (ArrayList)sharedDatalinks.get(name);
        Iterator iterator = list.iterator();

        while (iterator.hasNext())
        {
            DataHandler.Interface child =
                (DataHandler.Interface)iterator.next();

            child.getDataHandler().displayData();
        }
    }


    private void displayData()
    {
        Iterator iterator = new ComponentIterator(DataHandler.Interface.class);

        while (iterator.hasNext())
        {
            DataHandler.Interface child =
                (DataHandler.Interface)iterator.next();

            child.getDataHandler().displayData();
        }
    }


    private final static String MANDATORY_ERROR =
        "Some fields need to be completed.";
    private final static String VALIDATION_ERROR =
        "Some fields are in error.";


    private boolean storeData(boolean checkMandatory, boolean ignoreValidation)
    {
        Iterator iterator = new ComponentIterator(DataHandler.Interface.class);

        while (iterator.hasNext())
        {
            DataHandler.Interface child =
                (DataHandler.Interface)iterator.next();
            int result = child.getDataHandler().storeData();
            java.awt.Component component = (java.awt.Component)child;

            if (result == DataHandler.EMPTY && checkMandatory)
            {
                showErrorDialog(MANDATORY_ERROR, component);

                return false;
            }
            else if (result == DataHandler.INVALID && !ignoreValidation)
            {
                showErrorDialog(VALIDATION_ERROR, component);

                return false;
            }
        }

        return true;
    }


    private void showErrorDialog(final String message,
        final java.awt.Component component)
    {
        Toolkit.getDefaultToolkit().beep();

        final Frame frame = this;

        SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                JOptionPane.showMessageDialog(frame, message, "Error",
                    JOptionPane.WARNING_MESSAGE);

                component.requestFocus();
            }
        });
    }


    // ------------------------------------------------------------------------


    private HashMap colorHolderTable = new HashMap();


    private static class ColorHolder implements java.io.Serializable
    {
        private Color originalForeground, originalBackground;


        public ColorHolder(java.awt.Component parent)
        {
            originalForeground = parent.getForeground();
            originalBackground = parent.getBackground();
        }


        public Color getForeground() { return originalForeground; }


        public Color getBackground() { return originalBackground; }
    }


    protected void storeChildColors(Container container)
    {
        initializeComponentArray(container);

        for (int i = 0; i < componentArray.length; i++)
        {
            java.awt.Component child = componentArray[i];

            colorHolderTable.put(child, new ColorHolder(child));
        }
    }

    
    public void resetChildColors()
    {
        for (int i = 0; i < componentArray.length; i++)
        {
            java.awt.Component child = componentArray[i];
            resetForeground(child);
            resetBackground(child);
        }
    }
        

    public void resetForeground(java.awt.Component component)
    {
        ColorHolder holder = (ColorHolder)colorHolderTable.get(component);

        if (holder != null) component.setForeground(holder.getForeground());
        else Log.error(this, component + " is not a known child");
    }


    public void resetBackground(java.awt.Component component)
    {
        ColorHolder holder = (ColorHolder)colorHolderTable.get(component);

        if (holder != null) component.setBackground(holder.getBackground());
        else Log.error(this, component + " is not a known child");
    }


    // ------------------------------------------------------------------------


    static
    {
        String lookAndFeel=Config.instance().getString("lookAndFeel");

        if (lookAndFeel!=null)
        {
            Log.output("Attempting to override default look and feel to "+lookAndFeel+"..\n");

            try
            {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception e)
            {
                Log.output("Unable to set look and feel due to:\n"+e+"\n");
                lookAndFeel=null;
            }
        }

        try
        {
            if (lookAndFeel==null)
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e)
        {
        }

        Log.output("Using look and feel "+UIManager.getLookAndFeel()+"\n");
    }

    // ------------------------------------------------------------------------

    /**
     * This caches {@link javax.swing.Icon}s for use with
     * {@link TransmuteBitmap}s and {@link TransmuteButton}s.
     * <BR>
     */
    public static Icon createIcon(String resourcePath)
    {
        if (!imageIcons.containsKey(resourcePath))
        {
			// Assuming that the images are all in a zip/jar file thats in the classpath.        	 
			// To avoid the package prefix of class been prepended to the resoure path
			// e.g. com.ibm.ie.reeng.rt.client.<resourcePath> a "/" is added
			URL url = TransmuteDialog.class.getResource("/"+resourcePath);

            if (url != null)
            {
                imageIcons.put(resourcePath, new ImageIcon(url));
            }
            else
            {
                Log.error("com.ibm.ie.reeng.rt.client.TransmuteDialog"
                    , "could not find \"" + resourcePath + "\" in CLASSPATH");
                imageIcons.put(resourcePath, null);
            }
        }

        return (ImageIcon)imageIcons.get(resourcePath);
    }

    private static HashMap imageIcons = new HashMap();
    
    // ------------------------------------------------------------------------

    /**
     * This supports the Hps "custom" window colors concept. In Hps
     * these are pulled out of the .INI file at runtime. Here we pull
     * them out of runtime.properties.
     * <p>
     * The format of runtime.properties lines is as follows: <BR>
     *   windowcolors.&lt;custom window color name&gt; = &lt;color string&gt;
     * <BR>
     * Where &lt;color string&gt; is a comma separated RGB value or else
     * the name of one of the built in static colors defined in
     * java.awt.Color.
     */
    protected static Color getWindowColor(String name)
    {
        if (colorTable == null)
        {
            colorTable = new HashMap();

            colorTable.put("white", Color.white);
            colorTable.put("lightGray", Color.lightGray);
            colorTable.put("gray", Color.gray);
            colorTable.put("darkGray", Color.darkGray);
            colorTable.put("black", Color.black);
            colorTable.put("red", Color.red);
            colorTable.put("pink", Color.pink);
            colorTable.put("orange", Color.orange);
            colorTable.put("yellow", Color.yellow);
            colorTable.put("green", Color.green);
            colorTable.put("magenta", Color.magenta);
            colorTable.put("cyan", Color.cyan);
            colorTable.put("blue", Color.blue);
        }

        String key = "windowcolors." + name;
        String colorString = Config.instance().getString(key);

        if (colorString == null)
        {
            Log.error("TransmuteDialog", "property " + key + " is not set");
            return Color.black;
        }

        if (colorTable.containsKey(colorString))
            return (Color)colorTable.get(colorString);

        StringTokenizer toks = new StringTokenizer(colorString, ",");

        if (toks.countTokens() == 3)
        {   
            try
            {
                Color color = new Color(
                    Integer.parseInt(toks.nextToken()),
                    Integer.parseInt(toks.nextToken()),
                    Integer.parseInt(toks.nextToken()));

                colorTable.put(colorString, color);
                return color;
            }
            catch (Exception e)
            {
                Log.error("TransmuteDialog", "can't parse RGB color string "
                    + colorString + " for property " + key);
                return Color.black;
            }
        }
        else
        {
            Log.error("TransmuteDialog", "unknown color string " + colorString
                + " for property " + key);
            return Color.black;
        }
    }
    
    public TransmuteDialog getLogicalParent()
    {
    	return (TransmuteDialog)getWindowStack().peek();
    }
    

    private static HashMap colorTable;

    public String toString() { return Util.toString(this, 2); }
    
    //-------------------------------------------------------------------------------
    //to support alteredField functionality...
    // Vector alteredFields holds list of all AlteredField instances for this dialog instance
    private ArrayList alteredFields = new ArrayList();
    
   /**
    * "restores" all AlteredFields by emptying Vector
    */
    public void restoreAlteredFields()
    {
        alteredFields.clear();
    }
    
   /**
    * Adds AlteredField instance to Vector
    * Note that no checking is performed to see if the AlteredField instance is effectively
    * a duplicate of an existing Vector element.
    * @param details    AlteredField instance to be added
    */
    public void setAlteredField(AlteredField details)
    {
        alteredFields.add(details);
    }

   /**
    * returns alteredFields for this dialog instance
    * @return     alteredFields Vector
    */
    public ArrayList getAlteredFields()
    {
        return alteredFields;
    }
        
    //-------------------------------------------------------------------------------
}


/**
 * Hps uses strict (pixel or character based layout). This
 * <code>LayoutManager</code> supports this.
 */
class FixedSizeLayout extends Dimension implements LayoutManager,
    java.io.Serializable
{
    public void addLayoutComponent(String name, java.awt.Component comp) { }
    public void removeLayoutComponent(java.awt.Component comp) { }
    public void layoutContainer(Container parent) { }

    public Dimension preferredLayoutSize(Container parent) { return this; }
    public Dimension minimumLayoutSize(Container parent) { return this; }

    public FixedSizeLayout(Dimension d) { super(d); }

    public FixedSizeLayout(int width, int height) { super(width, height); }
}

/**
 * This is used as a mutex for certain events being generated.
 * Particularly table smooth scrolling events can cause glitches if the
 * user is allowed to continue dragging the scroll bar while the
 * application is processing an out of bounds exception.
 */
class ConverseLock implements java.io.Serializable
{
    private boolean inConverse;

    synchronized void waitForConverse() 
    {
        while (!isInConverse())
        {
            try { wait(); }
            catch (InterruptedException e) { Log.exception(e); }
        }
    }

    synchronized boolean isInConverse() { return inConverse; }

    synchronized void setInConverse(boolean newValue)
    {
        inConverse = newValue;
        notifyAll();
    }
}
