package com.ibm.ie.reeng.rt.client;

import javax.swing.SwingConstants;
import java.util.TreeMap;

/**
 * Represents a spreadsheet column. For editable tables, this class
 * keeps track of cells which contain invalid (error) values.
 */
public class TransmuteColumn implements Identifier, java.io.Serializable
{
    private String name;

    private int alignment = SwingConstants.LEFT;

    private int preferredWidth = 0; // No preference.

    private boolean editable = false;


    public TransmuteColumn(String name) { this.name = name; }


    public String toString() { return name; }


    public void setMaxLength(int length)
    {
// Calls to this should only be generated if readonly is off but...
    }


    public int getHorizontalAlignment() { return alignment; }


    public void setHorizontalAlignment(int alignment)
    {
        this.alignment = alignment;
    }


    public int getPreferredWidth() { return preferredWidth; }


    public void setPreferredWidth(int preferredWidth)
    {
        this.preferredWidth = preferredWidth;
    }


    public void setEditable(boolean b) { editable = b; }


    public boolean isEditable() { return editable; }


    // ------------------------------------------------------------------------


    private TreeMap errorRows = new TreeMap();


    private void addErrorRow(String value, int i)
    {
        errorRows.put(new Integer(i), value);
    }


    private String getErrorRow(int i)
    {
        return (String)errorRows.get(new Integer(i));
    }


    private void removeErrorRow(int i)
    {
        errorRows.remove(new Integer(i));
    }


    public boolean isErrorRow(int i)
    {
        return errorRows.containsKey(new Integer(i));
    }


    public int getFirstErrorRowIndex()
    {
        if (errorRows.isEmpty()) return -1;
        else return ((Integer)errorRows.firstKey()).intValue();
    }


    // ------------------------------------------------------------------------


    public void resetState()
    {
        errorRows = new TreeMap(); // Recreating is easier than clearing.
    }


    // ------------------------------------------------------------------------


    private ClientData clientData;


    public void setClientData(ClientData clientData)
    {
        this.clientData = clientData;
    }


    public String getString(int i)
    {
        String string = getErrorRow(i);

        return string != null ? string : clientData.getString(i);
    }


    public void setString(String string, int i)
    {
        if (clientData.setString(string, i)) removeErrorRow(i);
        else addErrorRow(string, i);
    }


    public Object get(int i) { return clientData.get(i); }


    public void set(Object o, int i)
    {
        clientData.set(o, i);
        removeErrorRow(i);
    }


    public void clear(int i)
    {
        clientData.clear(i);
        removeErrorRow(i);
    }


    public int getRowCount() { return clientData.getSize(); }

    // ------------------------------------------------------------------------
    // There is a lot of overlap with DataHandler. Unfortunately
    // TransmuteColumn's are not JComponents so we cannot reuse that
    // funtionality.

    private boolean immediateReturn = false;

    public void setImmediateReturn() { immediateReturn = true; }
    
    public void setImmediateReturn(boolean immediateReturn) 
    { 
        this.immediateReturn = immediateReturn; 
    }

    public boolean getImmediateReturn() { return immediateReturn; }

    public boolean isImmediateReturn() { return immediateReturn; }

    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }

    // ------------------------------------------------------------------------


    private LongName longName;

    public void setLongName(String name)
    {
        longName = new LongName(name);
    }

    public boolean matchLongName(String view, String field)
    {
        return longName != null 
            && longName.matches(view, field);
    }

    public String getPrimaryView() { return longName.getFirstView(); }

    public String getPrimaryField() { return longName.getField(); }
 
    // ------------------------------------------------------------------------
   /**
    * Method to specify new AlteredField to TransmuteDialog
    * @param row    specifies row number of altered cell (note: row numbers in HPS start with 1)
    */
    public void setAlteredField(int row)
    {
        TransmuteDialog dialog = TransmuteDialog.getCurrentDialog();
        if(dialog!=null)
            dialog.setAlteredField(new AlteredField(getPrimaryView(), getPrimaryField(), row));
    }

    // ------------------------------------------------------------------------
     
}
