package com.ibm.ie.reeng.rt.client;

import javax.swing.JCheckBox;

/**
 * A simple extension of {@link javax.swing.JCheckBox} to support some
 * functionality required by Hps system components.
 */
public class TransmuteCheckBox extends JCheckBox
    implements Identifier, DataHandler.Interface, java.io.Serializable
{
    private CheckBoxDataHandler handler = new CheckBoxDataHandler(this);

    public DataHandler getDataHandler() { return handler; }

    public TransmuteCheckBox() { super(); }
    public TransmuteCheckBox(String text) { super(text);}


    // ------------------------------------------------------------------------

    public void setClientData(ClientData clientData)
    {
        handler.setClientData(clientData);
    }

    public void setMandatory(boolean mandatory)
    {
        getDataHandler().setMandatory(mandatory);
    }

    public boolean getMandatory()
    {
        return getDataHandler().getMandatory();
    }

    public void setImmediateReturn(boolean immediateReturn)
    {
        getDataHandler().setImmediateReturn(immediateReturn);
    }

    public boolean getImmediateReturn()
    {
        return getDataHandler().getImmediateReturn();
    }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }
}
