package com.ibm.ie.reeng.rt.client;

import javax.swing.*;
import java.beans.*;

import java.awt.Insets;

/**
 * A simple extension of {@link javax.swing.JButton} to support some
 * functionality required by Hps system components.
 * <p>
 * Note the constructor calls {@link javax.swing.JButton#setDefaultCapable}
 * to disable Swing's currently broken default button handling. This
 * stops Swing clobbering our Actions for the the enter key which have
 * been set up in {@link TransmuteDialog#setEnterAction}.
 */
public class TransmuteButton extends JButton
    implements Identifier, Checking.Interface, java.io.Serializable
{
    public TransmuteButton()
    {
        super();
        setDefaultCapable(false);
    }
    
    public TransmuteButton(String text)
    {
        super(text);
        setDefaultCapable(false);
    }

    public TransmuteButton(Icon icon)
    {
        super(icon);
        setDefaultCapable(false);
    }

    public Insets getInsets() { return new Insets(0, 0, 0, 0); }

    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }


    // ------------------------------------------------------------------------


    private Checking checking = new Checking();


    public Checking checking() { return checking; }
}
