package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Util;

import java.text.ParsePosition;
import java.text.DecimalFormat;
import java.text.ParseException;


/**
 * A wrapper around an <code>int</code> or <code>double</code> member
 * variable which is used in conjunction with various GUI elements to
 * allow them to automatically get or set the member's value.
 * <p>
 * See {@link ClientData} for a general discussion.
 */
public class NumData extends ClientData
{
    private final static String DEFAULT_FORMAT = "0.#";

    private DecimalFormat decimalFormat;

    private double maxValue = Util.MAX_INTEGER;
    private double minValue = Util.MIN_INTEGER;


    private void setupFormat()
    {
        if (decimalFormat == null)
        {
            if (format == null) format = DEFAULT_FORMAT;
            
            decimalFormat = new DecimalFormat(format);
        }
    }


    public void setMinMax(double min, double max)
    {
        minValue = min;
        maxValue = max;
    }


    public void setMinMax(boolean isSigned,
        int integerDigits, int fractionDigits)
    {
        maxValue = Math.pow(10, integerDigits) - Math.pow(10, -fractionDigits);

        if (isSigned) minValue = -maxValue;
        else minValue = 0;
    }


    public String objectToString(Object object)
    {
        setupFormat();

        if (object instanceof Integer)
        {
            Integer value = (Integer)object;
            return decimalFormat.format(value.intValue());
        }
        else if (object instanceof Long)
        {
            Long value=(Long)object;
            return decimalFormat.format(value.longValue());
        }
        {
            Double value = (Double)object;
            return decimalFormat.format(value.doubleValue());
        }
    }


    public Object stringToObject(String string)
    {
        setupFormat();

        double value = 0;
        
        string = string.trim();

        // First try and parse the number using the given format,
        ParsePosition pos = new ParsePosition(0);
        Number num = decimalFormat.parse(string, pos);

        if (num != null && pos.getIndex() == string.length())
        {
            value = num.doubleValue();
        }
        else
        {
            // if that fails just try the default decimal format.
            try
            {
                //1.2KL value = Double.parseDouble(string);
                value = (Double.valueOf(string)).doubleValue();
            }
            catch (NumberFormatException ex)
            {
                return null;
            }
        }

        // ensure we don't silently strip precision.
        try
        {
            if (decimalFormat.parse(decimalFormat.format(value)).doubleValue()
                != value) return null;
        }
        catch (ParseException p)
        {
            // this should never happen.
            return null;
        }

        if (value < minValue || value > maxValue) return null;

        // If it should be an integer and has a fractional portion...
        if (isInteger() && value != (int)value) return null;

        return new Double(value);
    }


    private boolean isInteger()
    {
        Object o = get();

        if (o == null) o = get(0); // This is not ideal.

        return (o instanceof Integer);
    }
}
