package com.ibm.ie.reeng.rt.client;

import javax.swing.JComponent;
//import java.util.*;

import java.util.StringTokenizer;
import java.util.Iterator;
import java.util.LinkedList;

/**
 * Used to represent the "long name" identification of Hps GUI
 * components. These are composed of containing view name and optional
 * field names.
 */
public class LongName
{
    private String view = null;
    private String field = "";

    public LongName(String name)
    {
        StringTokenizer tokenizer
            = new StringTokenizer(name, ".<>[]", true);

        while (tokenizer.hasMoreTokens())
        {
            String token = tokenizer.nextToken();

            if (!token.equals("."))
            {
                if (token.equals("<"))
                {
                    token = tokenizer.nextToken();

                    if (view == null) view = token;

                    viewList.add(token);

                    tokenizer.nextToken(); // Discard ">".
                }
                else if (token.equals("["))
                {
                    field = tokenizer.nextToken();

                    tokenizer.nextToken(); // Discard "]".
                }
                else viewList.add(token);
            }
        }
    }

    public String getFirstView()
    {
        return view != null ? view : (String)viewList.getFirst();
    }

    public String getField() { return field; }

    public boolean matches(String otherView, String otherField)
    {
        return (otherView.equals("") || viewList.contains(otherView))
            && (otherField.equals("") || otherField.equals(field));
    }

    private LinkedList viewList = new LinkedList();

    /** For debugging purposes. */
    public String toString()
    {
        StringBuffer buf = new StringBuffer();
        Iterator i = viewList.iterator();
        while (i.hasNext())
        {
            buf.append(i.next());
            buf.append(".");
        }
        buf.append(field);
        return buf.toString();
    }
}
