package com.ibm.ie.reeng.rt.client;

/**
 * This class is used by {@link TransmuteList} instances to get and
 * retrieve "linked" data. For a general discussion of this topic see
 * {@link ClientData} and {@link DataHandler}.
 */
public class ListDataHandler extends DataHandler
{
    private TransmuteList listComponent;


    public ListDataHandler(TransmuteList listComponent)
    {
        super(listComponent);

        this.listComponent = listComponent;
    }


    //
    // Note: lists are readonly so super.stateChange() is never called.
    //


    public void displayData()
    {
        TransmuteList.DataModel model =
            (TransmuteList.DataModel)listComponent.getModel();

        model.fireContentsChanged();
    }


    public int storeData() { return VALID; }
}
