package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Log;

//import javax.swing.*;
import javax.swing.JList;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.UIManager;


import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.HashMap;
import java.util.Enumeration;
import java.util.ArrayList;

/**
 * This class provides a simple GUI to launch the rules associated with
 * rebased Hps processes. It relies on the generated "launch.properties"
 * file which maps process names to rules.
 */
public class Launcher
{
    public static final String bundleName = "launch";

    public static void main(String[] args)
    {
        new Launcher(args);
    }

    private ArrayList processNames = new ArrayList();
    private HashMap processToRule = new HashMap();
    private JList list;
    private Launcher(String[] args)
    {
        getRulesList();

        createFrame();
    }

    private void getRulesList()
    {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        Enumeration e = bundle.getKeys();
        while (e.hasMoreElements())
        {
            String hpsProcessName = (String)e.nextElement();
            String niceProcessName = humanReadable(hpsProcessName);
            String ruleClass = bundle.getString(hpsProcessName);
            processNames.add(niceProcessName);
            processToRule.put(niceProcessName, ruleClass);
        }
    }

    private void createFrame()
    {
        JFrame frame = new JFrame("Launcher");
        frame.getContentPane().setLayout(new FlowLayout());
        frame.addWindowListener(new WindowAdapter()
        {
            public void windowClosing(WindowEvent e)
            {
                System.exit(0);
            }
        });

        JButton runButton = new JButton("Run...");
        runButton.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                System.setProperty("business.process"
                    , (String)list.getSelectedValue());
                run(getSelectedRuleName());
            }
        });

        list = new JList(processNames.toArray());
        list.setPrototypeCellValue("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        list.setSelectedIndex(0);
        JScrollPane scrollPane = new JScrollPane(list);

        frame.getContentPane().add(scrollPane);
        frame.getContentPane().add(runButton);

        frame.pack();

        frame.setVisible(true);
    }

    private String getSelectedRuleName()
    {
        return (String)processToRule.get(list.getSelectedValue());
    }

    private void run(final String rule)
    {
        try
        {
            Log.information(this, "starting rule " + rule);

            ClientRule root = (ClientRule)Class.forName(rule).newInstance();
            RuleRunnable ruleRunnable = new RuleRunnable(root);

            ruleRunnable.start();
        }
        catch (Exception e)
        {
            Log.exception(e);
        }
    }


    private static class RuleRunnable extends Thread
    {
        private ClientRule root;


        public RuleRunnable(ClientRule root) { this.root = root; }


        public void run()
        {
            try
            {
                root.use();

                Log.information(this, "rule " + root + " exited normally");
            }
            catch (Exception e)
            {
                Log.exception(e);
            }
        }
    }


    private static String humanReadable(String name)
    {
        StringBuffer buf = new StringBuffer();
        char[] characters = name.toLowerCase().toCharArray();
        boolean upper = true;
        for (int i = 0; i < characters.length; i++)
        {
            if (characters[i] == '_')
            {
                upper = true;
                buf.append(" ");
            }
            else
            {
                if (upper)
                {
                    buf.append(Character.toUpperCase(characters[i]));
                    upper = false;
                }
                else buf.append(characters[i]);
            }
        }

        return buf.toString();
    }

    static
    {
        try
        {
            UIManager.setLookAndFeel(
                UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e)
        {
        }
    }
}
