package com.ibm.ie.reeng.rt.client; // Another package might be more appropriate?


import javax.swing.JTextField;
import javax.swing.text.Document;
import java.awt.event.KeyEvent;
import java.awt.event.InputMethodEvent;


/**
 * JDK BUG WORKAROUND.
 * <p>
 * This works around bug 4127078 - over which there is some confusion
 * whether its closed or not - apparently it's fixed in JDK 1.3.
 * <p>
 * Currently if an an accelerator is pressed while in a text field the
 * accelerator key ends up in the field (as well as firing the related
 * accelerator action). This work around corrects this behavior.
 */
class JTextFieldBugFix extends JTextField
{
    public JTextFieldBugFix() { }

    public JTextFieldBugFix(Document doc, String text, int columns)
    {
        super(doc, text, columns);
    }

    public JTextFieldBugFix(int columns) { super(columns); }

    public JTextFieldBugFix(String text) { super(text); }

    public JTextFieldBugFix(String text, int columns) { super(text, columns); }
       

    // ------------------------------------------------------------------------


    private boolean altPressed = false;


    protected void processComponentKeyEvent(KeyEvent event)
    {
        super.processComponentKeyEvent(event);
        altPressed = event.isAltDown();
    }


    protected void processInputMethodEvent(InputMethodEvent e)
    {
        if (altPressed) e.consume();
        super.processInputMethodEvent(e);
    }
}
