package com.ibm.ie.reeng.rt.client;

import javax.swing.JLabel;
import java.awt.Canvas;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Event;
import java.awt.Font;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.FontMetrics;
import java.awt.Dimension;

import java.util.StringTokenizer;

import javax.swing.JDialog;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
//Pasha 3/1/01
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.Icon;
import java.net.*;
import java.util.*;
//End
import javax.swing.JRootPane;
import java.awt.event.WindowAdapter;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.ActionEvent;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Log;

public class InfoDialog extends JDialog 
{
  public static final int LEFT = 0, CENTER = 1, RIGHT = 2; // alignment values
	protected MultiLineLabel label;
	protected JButton button;
	private JFrame parentFrame;

  public class MultiLineLabel extends Canvas
  {
	protected String label;
	protected int margin_width;
	protected int margin_height;
	protected int alignment;
	protected int num_lines;
	protected String[] lines;
	protected int[] line_widths;
	protected int line_height;          // Total height of the font
	protected int line_ascent;          // Font height above baseline
	protected boolean measured = false; // Have the lines been measured?
	protected int max_width;            // The width of the widest line
	
	public MultiLineLabel(String pLabel, int margin_width, int margin_height)
	{	
	  this(pLabel,margin_width,margin_height,LEFT);	
	}
	
	public MultiLineLabel(String pLabel,int margin_width, int margin_height, int alignment)
	{
	  this.label = pLabel;
	  this.margin_width = margin_width;
	  this.margin_height= margin_height;
	  this.alignment = alignment;
	  newLabel();
	}
   
	/** This internal method breaks a specified label up into an array of lines.
	  *  It uses the StringTokenizer utility class. */
	  
	protected synchronized void newLabel() 
	{
	  StringTokenizer t = new StringTokenizer(label, "\n");
	  num_lines = t.countTokens();
	  lines = new String[num_lines];
	  line_widths = new int[num_lines];
	  for(int i = 0; i < num_lines; i++) lines[i] = t.nextToken();
	}
	
	public MultiLineLabel(String pLabel) { this(pLabel, 10, 10, LEFT); }
	public MultiLineLabel() { this(""); }
	
	// Methods to set and query the various attributes of the component
	// Note that some query methods are inherited from the superclass.
	public void setLabel(String pLabel) 
	{
	  this.label = pLabel;
	  newLabel();               // Break the label into lines
	  measured = false;         // Note that we need to measure lines
	  this.repaint();           // Request a redraw
	}
	
	public void setFont(Font f) 
	{
	  super.setFont(f);         // tell our superclass about the new font
	  measured = false;         // Note that we need to remeasure lines
	  this.repaint();                // Request a redraw
	}
	
	public void setForeground(Color c) 
	{
	  super.setForeground(c);   // tell our superclass about the new color
	  this.repaint();                // Request a redraw (size is unchanged)
	}
	
	public void setAlignment(int a) { alignment = a; this.repaint(); }
	public void setMarginWidth(int mw) { margin_width = mw; this.repaint(); }
	public void setMarginHeight(int mh) { margin_height = mh; this.repaint(); }
	public final String getLabel() { return label; }
	public final int getAlignment() { return alignment; }
	public final int getMarginWidth() { return margin_width; }
	public final int getMarginHeight() { return margin_height; }
	
	/**
	  * This method is called by a layout manager when it wants to
	  * know how big we'd like to be.  
	  */
	  
	public Dimension getPreferredSize() 
	{
	  if (!measured) 
		measure();
	  
	  return new Dimension(max_width + 2*margin_width, num_lines * line_height + 2*margin_height);
	}
	
	public Dimension getMinimumSize() { return getPreferredSize(); }
	
	public void paint(Graphics g) 
	{
	  int x, y;
	  Dimension size = this.getSize();  
	  if (!measured) 
		measure();
	  
	  y = line_ascent + (size.height - num_lines * line_height)/2;
	  for(int i = 0; i < num_lines; i++, y += line_height) 
	  {
		switch(alignment) 
		{
		  default:
		  case LEFT:    x = margin_width; break;
		  case CENTER:  x = (size.width - line_widths[i])/2; break;
		  case RIGHT:   x = size.width - margin_width - line_widths[i]; break;
		}
		g.drawString(lines[i], x, y);
	  }
	}
	
	/** This internal method figures out how the font is, and how wide each
	 *  line of the label is, and how wide the widest line is. 
	 */
	 
	protected synchronized void measure() 
	{
	  FontMetrics fm = this.getToolkit().getFontMetrics(this.getFont());
	  line_height = fm.getHeight();
	  line_ascent = fm.getAscent();
	  max_width = 0;
	  for(int i = 0; i < num_lines; i++) 
	  {
		line_widths[i] = fm.stringWidth(lines[i]);
		if (line_widths[i] > max_width) 
		  max_width = line_widths[i];
	  }
	  measured = true;
	}
  }
  
/**
 * Constructor for Hourglass
 * Creation date: (3/1/01 3:58:57 PM)
 * Pasha 
 */
public InfoDialog(String title) 
{
	super();
	parentFrame = null;
	this.setTitle(title);
	this.getContentPane().setLayout(new BorderLayout());
	JLabel jLabel = new JLabel(createHourglass("/images/hourglass.gif"));
	this.getContentPane().add(jLabel, BorderLayout.CENTER);
	
	JPanel p = new JPanel();
		
	// final JDialog infoDialog = this;
	
	this.getContentPane().add("South",p);
	this.pack();

	setResizable(false);

	// The application controls windows closing.
	setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
}
  public InfoDialog(String title, String message)
	{
	super();
	parentFrame = null;
	this.setTitle(title);
	this.getContentPane().setLayout(new BorderLayout(15,15));
	label = new MultiLineLabel(message,20,20);
	this.getContentPane().add("Center",label);
	Font font = new Font(label.getFont().getName(), Font.BOLD, 15);
	label.setFont(font);
	label.setAlignment(this.CENTER);
	
	button = new JButton("OK");
	JPanel p = new JPanel();
	p.setLayout(new FlowLayout(FlowLayout.CENTER,15,15));
	p.add(button);
		
	final JDialog infoDialog = this;
	
	button.addActionListener(new ActionListener()
	{
	  public void actionPerformed(ActionEvent ae)
	  { 
		infoDialog.setVisible(false); 
		infoDialog.dispose();
	  }
	});

	this.getContentPane().add("South",p);
	this.pack();
  
  }  
  public InfoDialog(JFrame parent, String title, String message)
	{
	super(parent,title,false);
	parentFrame = parent;
	this.getContentPane().setLayout(new BorderLayout(15,15));
	label = new MultiLineLabel(message,20,20);
	this.getContentPane().add("Center",label);
	
	button = new JButton("OK");
	JPanel p = new JPanel();
	p.setLayout(new FlowLayout(FlowLayout.CENTER,15,15));
	p.add(button);
		
	final JDialog infoDialog = this;
	
	button.addActionListener(new ActionListener()
	{
	  public void actionPerformed(ActionEvent ae)
	  { 
		infoDialog.setVisible(false); 
		infoDialog.dispose();
	  }
	});

	this.getContentPane().add("South",p);
	this.pack();
  
  }  
/**
 * Method loading Hourglass
 * Creation date: (3/1/01 4:53:16 PM)
 * Pasha
 */
public static Icon createHourglass(String resourcePath) 
{
		Hashtable imageIcons = new Hashtable();
		if (!imageIcons.containsKey(resourcePath))
		{
	  		URL url = ClassLoader.getSystemResource(resourcePath);
	  
			if (url != null)
			{
				imageIcons.put(resourcePath, new ImageIcon(url));
			}
			else
			{
				String codebase = Config.instance().getProperty("applet.codebase", "http://localhost/webapp/otp/");
				String imgPath = codebase + resourcePath.substring(1);
				Log.information("TransmuteDialog", "Attempting to create URL: " + imgPath + " for imageIcon");
				
				try
				{
				  imageIcons.put(resourcePath, new ImageIcon(new URL(imgPath)));
				}
				catch (MalformedURLException murle)
				{
				  murle.printStackTrace();
				}
			}
		}

		return (ImageIcon)imageIcons.get(resourcePath);
}
}
