package com.ibm.ie.reeng.rt.client;

/**
 * Many GUI related system components are "deferred". Such components
 * have no effect on the application state until the next window is
 * conversed. Such components create implementations of this class which
 * are registered using {@link TransmuteDialog#addDeferred}.
 */
public abstract class DeferredComponent
{
    /**
     * Subclasses implement this to change properties of the dialog.
     */
    public abstract void use(TransmuteDialog dialog);

    private Thread instantiatingThread;
    
    public void setInstantiatingThread(Thread t)
    {
        instantiatingThread=t;
    }

    public Thread getInstantiatingThread()
    {
        return instantiatingThread;
    }
}
