package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Util;
import com.ibm.ie.reeng.rt.common.Marshall;
import com.ibm.ie.reeng.rt.common.comms.CtgComms;

import com.ibm.ctg.client.JavaGateway;
import com.ibm.ctg.client.ECIRequest;

import java.util.Arrays;
import java.net.UnknownHostException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CtgClientComms extends CtgComms
{

    public CtgClientComms()
    {
        if(!initialised)
        {
            initCtgConfigData(getProperty("jgate.url"),
                              getProperty("cics.server"),
                              getProperty("cics.router"),
                              Config.instance().getInt("cics.commareasize"),
                              getProperty("server.codepage"),
                              Config.instance().getBoolean("ctgcomms.debug"));
        }

     
        String sessionId = generateSessionId();
        
        // check for username & password.
        LogonDialog logon = new LogonDialog(
            "Please logon", getProperty("cics.defaultuser"),
            getProperty("cics.defaultpassword"));
        
        String userName = logon.getUserName();
        String password = logon.getPassword();

        
        initCtgConnection(sessionId,
                          userName,
                          password);
    }



    private static String getProperty(String name)
    {
        return Config.instance().getString(name);
    }

    /**
     * This isn't as simple as it would seem. There is no portable way
     * to generate a unique ID for a JVM instance. We use some of the
     * ideas from {@link java.rmi.server.UID}.
     * <P>
     * However we are not concerned with temporally disjoint uniqueness
     * (I invented that term - i.e. if instances of the JVM don't
     * concurrently exist then they may use the same ID.) so we don't
     * inject a time element.
     * <P>
     * Also note that the session ids must fit into 11 characters. I'm
     * not sure whether this is a consequence of the current Router
     * implementation or whether it is a CICS thing. I suspect the
     * former. Actually because of this we are not adding JVM
     * uniqueness.
     */
    private String generateSessionId()
    {
        String sessionId = "";
    
        try
        {
            // machine unique:
            int hostUID = java.net.InetAddress.getLocalHost().hashCode();

            // make positive:
            long id = (long)hostUID - (long)Integer.MIN_VALUE;
            sessionId =  "+" + Util.padLeft(String.valueOf(id), 10, Util.ZERO);
        }
        catch(UnknownHostException e)
        {
            fatalException(e);
        }
        
        return sessionId;
    }



    protected void information(String s)
    {
        Log.information(this,"CtgEjbComms INFO: " + s);
    }

    protected void requestError(ECIRequest req, String extra)
    {
        information("CtgEjbComms ERROR: CICS Transaction Gateway falure: RC = "
            + req.getCicsRcString() + ". " + extra);
    }

    protected void fatalError(String s)
    {
        Log.fatalError(this,s);   
    }

    protected void fatalException(Exception e)
    {
        Log.fatalException(e);   
    }
}
