package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Util;


/**
 * GUI elements in the Hps model (text fields, combo-boxes, etc.) are
 * linked to "data fields". As the user interacts with the GUI elements (by
 * typing text into a field for example) the corresponding "data" field
 * is updated accordingly. There are two heirarchies of runtime classes
 * provided to support this fuctionality one extending {@link DataHandler}
 * and the other extending this class.
 * <p>
 * Subclasses of this class are specific to the type of the member variable
 * being linked to, while the subclasses of {@link DataHandler} are
 * specific to the type GUI element. This dual "Adapter" pattern is
 * required because a single GUI element can be linked to different
 * types of member variables and visa-versa.
 * <p>
 * Thus in terms of association, data manipulating GUI elements are
 * associated with a {@link DataHandler} which is associated with a
 * {@link ClientData}.
 * <p>
 * Effectively the
 * {@link DataHandler} subclasses abstract away the differences between
 * GUI elements while the <code>ClientData</code> subclasses abstract
 * away the differences between different types of member variables.
 * The latter abstraction is achieved by providing a "stringified"
 * interface for getting or setting the data. 
 * <p>
 * Subclasses of this class are provided for linking to different types
 * of field (for example {@link DateData} is provided for linkage to a
 * java.sql.Data field). These classes are used in the generated code as
 * follows:
 * <PRE>
 *   textField = new TransmuteTextField();
 *   clientData = new CharData()
 *   {
 *     public Object get()
 *     {
 *       return windowChildView.firstName;
 *     }
 *     public void set(Object object)
 *     {
 *       windowChildView.firstName = stringValue(object);
 *     }
 *   };
 *   textField.setClientData(clientData);
 * </PRE>
 * Note in this example, {@link CharData} is a subclass specifically for
 * linking to <code>String</code> fields. In this way the instance of
 * <code>TransmuteTextField</code> can retrieve or update the linked
 * data by using the <code>get</code> and <code>set</code> methods.
 * <p>
 * Note the entire public interface for ClientData and its descendants is
 * defined here. Many of the functions are of no relevance at this level
 * but can be implemented in descendants to provide behavior determined
 * at that level.
 */
public class ClientData implements java.io.Serializable
{
    public Object get() { return null; }


    public void set(Object object) { }


    protected Object get(int i) { return null; }


    protected void set(Object object, int i) { }


    protected int getSize() { return 0; }


    // ------------------------------------------------------------------------


    protected int intValue(Object object)
    {
        return ((Number)object).intValue();
    }

    protected long longValue(Object object)
    {
        return ((Number)object).longValue();
    }

    protected double doubleValue(Object object)
    {
        return ((Number)object).doubleValue();
    }

    protected String stringValue(Object object) { return object.toString(); }

    protected Object intObject(int value) { return new Integer(value); }

    protected Object doubleObject(double value) { return new Double(value); }

    protected Object longObject(long value) { return new Long(value); }


    // ------------------------------------------------------------------------


    protected String objectToString(Object object) { return null; }


    protected Object stringToObject(String string) { return null; }


    // ------------------------------------------------------------------------


    public String getString()
    {
        return objectToString(get());
    }


    public boolean setString(String string)
    {
        Object object = stringToObject(string);

        if (object == null) return false;
        else
        {
            set(object);

            return true;
        }
    }


    public void clear() { set(Util.getClearValue(get())); }


    public void clear(int i) { set(Util.getClearValue(get(i)), i); }


    public String getString(int i)
    {
        return objectToString(get(i));
    }


    public boolean setString(String string, int i)
    {
        Object object = stringToObject(string);

        if (object == null) return false;
        {
            set(object, i);

            return true;
        }
    }


    // ------------------------------------------------------------------------


    protected String format;


    public void setFormat(String format) { this.format = format; }


    // ------------------------------------------------------------------------


    /**
     * MinMax is only implemented by NumData.
     */
    public void setMinMax(double min, double max) { }


    public void setMinMax(boolean isSigned,
            int integerDigits, int fractionDigits) { }


    // ------------------------------------------------------------------------


    // Note: perhaps this should be in the individual components.


    private int length = Integer.MAX_VALUE;


    public void setMaxLength(int length) { this.length = length; }


    public int getMaxLength() { return length; }
}
