package com.ibm.ie.reeng.rt.client;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;


/**
 * This class is used by {@link TransmuteCheckBox} instances to get and
 * retrieve "linked" data. For a general discussion of this topic see
 * {@link ClientData}.
 */
public class CheckBoxDataHandler extends DataHandler implements ItemListener
{
    private TransmuteCheckBox checkBox;
    private boolean internalStateChange = false;


    public CheckBoxDataHandler(TransmuteCheckBox checkBox)
    {
        super(checkBox);

        this.checkBox = checkBox;

        checkBox.addItemListener(this);
    }


    public void itemStateChanged(ItemEvent event)
    {
        if (internalStateChange) return;

        stateChanged();
    }


    public void displayData()
    {
        if (clientData == null) return;

        String data = clientData.get().toString();
        boolean selected;

        if (data.length() >= 1)
        {
            char c = data.charAt(0);

            selected = (c == 'x' || c == 'X');
        }
        else selected = false;

        internalStateChange = true;
        checkBox.setSelected(selected);
        internalStateChange = false;
    }


    public int storeData()
    {
        if (clientData != null)
            clientData.set(checkBox.isSelected() ? "X" : "");

        return VALID;
    }
}
