package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Log;

/**
 * A wrapper around a <code>String</code> member variable which is used
 * in conjunction with various GUI elements to allow them to
 * automatically get or set the member's value.
 * <p>
 * See {@link ClientData} for a general discussion.
 */
public class CharData extends ClientData
{
    public final static String UPPER = "UPPER";
    public final static String LOWER = "LOWER";
    public final static String FIRSTUPPER = "FIRSTUPPER";
    public final static String ALLFIRSTUPPER = "ALLFIRSTUPPER";


    public String objectToString(Object object)
    {
        String string = object.toString();

        if (format != null)
        {
            if (format == UPPER) string = string.toUpperCase();
            else if (format == LOWER) string = string.toLowerCase();
            else if (format == FIRSTUPPER)
            {
                if (string.length() > 0)
                {
                    StringBuffer buffer = new StringBuffer(string.toLowerCase());
                    buffer.setCharAt(0,
                        Character.toUpperCase(buffer.charAt(0)));
                    string = buffer.toString();
                }
            }
            else if (format == ALLFIRSTUPPER)
            {
                StringBuffer buffer = new StringBuffer(string.toLowerCase());
                boolean capital = true;

                for (int i = 0; i < buffer.length(); i++)
                {
                    char c = buffer.charAt(i);

                    if (Character.isLetter(c))
                    {
                        if (capital)
                        {
                            buffer.setCharAt(i, Character.toUpperCase(c));
                            capital = false;
                        }
                    }
                    else if (!Character.isDigit(c))
                    {
                        capital = true;
                    }
                }
                string = buffer.toString();
            }
            else Log.fatalError(this, "unknown format " + format);
        }

        return string;
    }


    public Object stringToObject(String string)
    {
        if (string.length() > getMaxLength()) return null;
        else return string;
    }
}
