package com.ibm.ie.reeng.rt.client;

/**
 * Class to hold details of any GUI fields altered by the end-user.
 * It describes the altered field using its view name, field name and
 * the fieldOccur number (only relevant for TransmuteTables)
 * <p>
 * As we do not have a clear specification of the altered field functionality in HPS, 
 * this implementation may not have exactly the same behaviour as its HPS equivalent.
 * <p>
 * Existing design of Altered Field functionality:
 * The following GUI components must support the notion of Altered Field :
 * TransmuteTextField, TransmuteRadioButton, TransmuteCheckBox, TransmuteComboBox, 
 * TransmuteTable.  
 * In order to capture the "field altering" event, code has been inserted in the 
 * following classes:  
 * DataHandler, TransmuteTableModel, TransmuteColumn and TransmuteComboBox.  
 * This is the least satisfactory part of the current implementation. That said, it seems
 * to work...
 * When a field is altered, a new AlteredField object is added to the alteredFields Vector
 * of the parent TransmuteDialog instance.  There is no checking for duplicates, so
 * if the same field is altered twice, it will appear twice in the Vector.  
 * Examination of existing use of the altered field components semed to indicate that this
 * should not be a problem.
 * <p>
 * The GetAlteredField system component checks the contents of the alteredField Vector
 * for fields which match its search criteria (ViewLongName, FieldLongName and FieldOccur).
 * <p>
 * The RestoreAlteredField system component simply removes all of the AlteredField objects
 * in the alteredFields Vector belonging to the TransmuteDialog specified in its input view.
 * <p>
 * An alternative implementation involved adding a boolean flag
 * to each relevant GUI component or associated DataHandler.  This resulted in 
 * some complicated and poor-performing code in the GetAlteredField component
 * 
 * @see transmute.runtime.system.component.GetAlteredField
 * @see transmute.runtime.system.component.RestoreAlteredFields
 *
 */
public class AlteredField
{
    public String field;
    public String view;    
    public int occur = 0;
    
    public AlteredField(String view, String field)
    {
        this(view, field, 0);
    }
    
    public AlteredField(String view, String field, int occur)
    {
        this.view = view;
        this.field = field;
        this.occur = occur;
    }
    
    /**
     * Checks if this instance is a match for input parameters 
     * @param view    match for viewLongName, or empty String indicating wildcard
     * @param field   match for fieldLongName, or empty String indicating wildcard
     * @param view    match for fieldOccur, or 0 or -1 indicating wildcard
     * @return <code>true</code> if valid match
     *         <code>false</code> otherwise
     */
    public boolean match(String view, String field, int occur)
    {
        if ((field.equals("") || field.equals(this.field))
            && (view.equals("") || view.equals(this.view))
            && (occur == 0 || occur == -1 || occur == this.occur)) 
            return true;
        else 
            return false;
    }
    
    public String toString()
    {
        return("AlteredField detail: View= "+this.view+" Field= "+this.field+" Occur= "+occur);
    }
}
