      *
      *
      * Module Name        EP03.CCP
      *
      * Descriptive Name   CICS External Presentation Interface
      *
      * Statement:         Licensed Materials - Property of IBM
      *
      *                    5724-D12
      *                    (c) Copyright IBM Corporation 1994,2002
      *
      *                    See Copyright Instructions.
      *
      *                    All rights reserved.
      *
      *                    U.S. Government Users Restricted Rights -
      *                    use duplication or disclosure restricted by
      *                    GSA ADP Schedule Contract with IBM Corp.
      *
      * Status:            Version 5 Release 1
      * NOTES :-
      *
      * This server program runs an ATI transaction.
      *
      * EP03 is a Basic CICS Server COBOL sample program which is used
      * with the frontend sample programs to demonstrate the use of
      * External Presentation Interface (EPI).
      *
      * The following code is sample code created by IBM Corporation.
      * This sample code is not part of any standard IBM product and
      * is provided to you solely for the purpose of assisting you in
      * the development of your applications. The code is provided 'as
      * is', without warranty or condition of any kind.  IBM shall not
      * be liable for any damages arising out of your use of the
      * sample code, even if IBM has been advised of the possibility
      * of such damages.
      *
      * Sample Output:
      *
      * To unit test this program use transaction EP03 as follows:
      *  Input on the CICS terminal:      Output from CICS terminal:
      *
      * 'EP03'                        -> 'ISSUED EXEC CICS START.'
      *  EP03 will issue an EXEC CICS START to run itself again
      *  and will then display        -> 'STARTED AS AN ATI.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. EP03.

       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      * Working storage starts here
      *
       01  FILLER                            PIC X(32)  VALUE
           '** Working storage starts here**'.

      *
      * This WS area contains all working variables.                   
      *
       01  FILLER                           PIC X(8)   VALUE 'WS-'.
       01  WS-WORK-FIELDS.
           05  WS-EP01                      PIC X(4) VALUE 'EP01'.
           05  WS-STARTCODE PIC XX.
                  88   TERMINAL-INPUT       VALUE 'TD'.
       01  OUTBOUND-DATA.
           05  OUT-MESSAGE.
               10  PIC X(45).
       01  OUTBOUND-DATA2.
           05  OUT-MESSAGE1.
               10  PIC X(45) VALUE
                    'ISSUED EXEC CICS START.                      '.
           05  OUT-MESSAGE2.
               10  PIC X(45) VALUE
                    'STARTED AS AN ATI.                           '.

      *
       LINKAGE SECTION.
      *

      *
       PROCEDURE DIVISION.
      *
       A-CONTROL SECTION.
           EXEC CICS ASSIGN STARTCODE(WS-STARTCODE) END-EXEC.
           IF TERMINAL-INPUT
              PERFORM B-DO-START
              MOVE OUT-MESSAGE1 TO OUT-MESSAGE
           ELSE
              MOVE OUT-MESSAGE2 TO OUT-MESSAGE
           END-IF
           PERFORM C-SEND-MSG-TO-CLIENT.
           EXEC CICS RETURN END-EXEC.
           GOBACK.
       A-END.
           EXIT.

      *
      *  Issue a START or EP01                                      
      *
       B-DO-START SECTION.
       B1.
           EXEC CICS
               START
               TRANSID(EIBTRNID)
               TERMID(EIBTRMID)
           END-EXEC.

       B-END.
           EXIT.

      *
      * Sends our message back to the client.                       
      *
       C-SEND-MSG-TO-CLIENT SECTION.
       C1.
           EXEC CICS
                SEND
                ERASE
                FROM(OUTBOUND-DATA)
                LENGTH(LENGTH OF OUTBOUND-DATA)
           END-EXEC.
       C-END.
           EXIT.

           EXIT.
           EJECT
      *end of program

