      *
      *                                                                
      * Module name        EP02.CCP                                    
      *                                                                
      * Descriptive name   CICS External Presentation Interface        
      *                                                                
      * Statement:         Licensed Materials - Property of IBM        
      *                                                                
      *                    5724-D12                                    
      *                    (c) Copyright IBM Corporation 1999, 2002    
      *                                                                
      *                    See Copyright Instructions.                 
      *                                                                
      *                    All rights reserved.                        
      *                                                                
      *                    U.S. Government Users Restricted Rights -   
      *                    use duplication or disclosure restricted by 
      *                    GSA ADP Schedule Contract with IBM Corp.    
      *                                                                
      * Status:            Version 5 Release 1                         
      * Notes :-                                                       
      *                                                                
      * This server program returns the date and time.                 
      *                                                                
      * EP02 is a Basic CICS Server Cobol sample program which is used 
      * with the frontend sample programs to demonstrate the use of    
      * External Presentation Interface (EPI).                         
      *                                                                
      * The following code is sample code created by IBM Corporation.  
      * This sample code is not part of any standard IBM product and   
      * is provided to you solely for the purpose of assisting you in  
      * the development of your applications. The code is provided 'as 
      * is', without warranty or condition of any kind.  IBM shall not 
      * be liable for any damages arising out of your use of the       
      * sample code, even if IBM has been advised of the possibility   
      * of such damages.                                               
      *
      * Sample Output:                                                 
      *                                                   
      * To unit test this program use transaction EP02 as follows:     
      * The BMS screen displayed looks as follows:                     
      *                                                                
      *                    
      *       Test Number:   000000001 st run of EP02                
      *                                                              
      *       Test Time:     31/12/00 23:59:59                      
      *                                                              
      *       Repeat(Y/N)?   Y                                       
      *                    
      *                                                                
      * To exit the screen enter the ATTN/Esc key or PF3/PF12.         
      *                                                                
      *

       IDENTIFICATION DIVISION.
       PROGRAM-ID. EP02.

       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      * Working storage starts here                                   
      *
       01  FILLER                            PIC X(32)  VALUE
           '** Working storage starts here**'.

      *
      * This WS area contains all switches and flags.                 
      *
       01  FILLER                           PIC X(8)   VALUE 'WS-'.
       01  WS-DEBUG-AREA.
           05 WS-PROG-NAME                  PIC X(16) VALUE SPACES.
           05 WS-PROG-SECT-NAME             PIC X(32) VALUE SPACES.
           05 WS-COMMAREA                   PIC X(1)  VALUE SPACES.
           05 WS-RAWTIME                    PIC S9(15) COMP-3.
           05 WS-IN-EIBCALEN                PIC 9(8) COMP VALUE 80.
           05 WS-EIBRESP                    PIC S9(8) COMP.
           05 WS-EIBRESP-DISP               PIC S9(9)
              SIGN LEADING SEPARATE.
           05  WS-DEBUG-ON-FLAG             PIC X VALUE 'Y'.
               88  DEBUG-ON                 VALUE 'Y'.
           05  WS-SEND-DATA-FLAG            PIC X.
               88  SEND-ERASE               VALUE '1'.
               88  SEND-DATAONLY            VALUE '2'.
               88  SEND-DATAONLY-ALARM      VALUE '3'.
               88  SEND-CLEAR-SCREEN        VALUE '4'.
           05  VALID-DATA-SW                PIC X VALUE 'Y'.
               88  VALID-DATA               VALUE 'Y'.
               88  INVALID-DATA             VALUE 'N'.

       01  MSG-FIELDS.
           05  MSG-CICS-RESPONSE-CODES.
               10  FILLER                   PIC X(20) VALUE
                                            'EIBRESP & EIBRESP2: '.
               10 MSG-CICS-RESP             OCCURS 2 TIMES
                                            PIC X(10).
               10  FILLER                   PIC X(40) VALUE SPACES.

       01  WS-WORK-FIELDS.
           05  WS-COUNT                     PIC  9(9) VALUE 0.
           05  WS-COUNTO REDEFINES WS-COUNT.
               10  WS-COUNTO-CHAR PIC X OCCURS 9.
           05  WS-DATETIME.
               10  WS-DATE-OUT              PIC X(8) VALUE '00/00/00'.
               10  WS-SPACE-OUT             PIC X(1) VALUE SPACE.
               10  WS-TIME-OUT              PIC X(8) VALUE '00:00:00'.
               10  WS-LOWVAL-OUT            PIC X(1) VALUE LOW-VALUE.
      * To test one iteration of this tran change the following
      * flag from 'Y' to 'N' so you get 'Test Run 000000001' only.
           05  WS-REPEATYN                  PIC X(1) VALUE 'Y'.

       COPY DFHAID.
       COPY EP02MAP.

      *
       LINKAGE SECTION.
      *
       01  DFHCOMMAREA                      PIC  X(1).

      *
       PROCEDURE DIVISION.
      *
       A-CONTROL SECTION.

           MOVE 'EP02'                 TO WS-PROG-NAME.
           MOVE 'A-'                   TO WS-PROG-SECT-NAME.

           IF DEBUG-ON
               EXEC CICS HANDLE CONDITION
                   ERROR(ZZX-CICS-ERROR-ROUTINE)
               END-EXEC
           END-IF.
           IF EIBCALEN = 0
               PERFORM B-INITIALIZE
           ELSE
               PERFORM XA-RECEIVE-EP02MAP
           END-IF.
           PERFORM C-EDIT-MAP

           EVALUATE TRUE
           WHEN EIBCALEN = 0
               SET SEND-ERASE TO TRUE
               PERFORM XB-SEND-EP02MAP
           WHEN EIBAID = DFHCLEAR OR DFHPF3 OR DFHPF12
               EXEC CICS RETURN END-EXEC
           WHEN EIBAID = DFHENTER
               IF REPEATYNO = 'Y' OR 'y'
               THEN
                   SET SEND-DATAONLY TO TRUE
                   PERFORM XB-SEND-EP02MAP
               ELSE
                   SET SEND-CLEAR-SCREEN TO TRUE
                   PERFORM XB-SEND-EP02MAP
               END-IF
           WHEN OTHER
               SET SEND-DATAONLY-ALARM TO TRUE
               PERFORM XB-SEND-EP02MAP
           END-EVALUATE.

           IF REPEATYNO = 'Y' OR 'y'
           THEN
               EXEC CICS
                   RETURN TRANSID('EP02')
                   COMMAREA(WS-COMMAREA)
                   LENGTH(LENGTH OF WS-COMMAREA)
               END-EXEC
           ELSE
               EXEC CICS
                   RETURN
               END-EXEC
           END-IF.
           GOBACK.

       A-EXIT.
           EXIT.

      *
       B-INITIALIZE SECTION.
      *

           MOVE LOW-VALUES          TO EP02MAPI
           MOVE 'B-'                TO WS-PROG-SECT-NAME.
           MOVE 0                   TO COUNTI
                                       WS-COUNT.
           MOVE 'Y'                 TO REPEATYNI.

       B-EXIT.
           EXIT.

      *
       C-EDIT-MAP SECTION.
      *

           MOVE 'C-'                   TO WS-PROG-SECT-NAME.

           ADD  1        TO COUNTI
                            WS-COUNT.

           EVALUATE WS-COUNTO-CHAR(9) ALSO WS-COUNTO-CHAR (8)
           WHEN '1' ALSO NOT '1'
               MOVE 'st run of EP02' TO MESSAGEO
           WHEN '2' ALSO NOT '1'
               MOVE 'nd run of EP02' TO MESSAGEO
           WHEN '3' ALSO NOT '1'
               MOVE 'rd run of EP02' TO MESSAGEO
           WHEN OTHER
               MOVE 'th run of EP02' TO MESSAGEO
           END-EVALUATE.

      *    DateTime:
           EXEC CICS
               ASKTIME ABSTIME(WS-RAWTIME)
           END-EXEC.
           EXEC CICS
               FORMATTIME ABSTIME(WS-RAWTIME)
                          DDMMYY(WS-DATE-OUT)
                          DATESEP('/')
                          TIME(WS-TIME-OUT)
                          TIMESEP(':')
           END-EXEC.
           MOVE WS-DATETIME TO DATETIMEO.

       C-EXIT.
           EXIT.

      *
       XA-RECEIVE-EP02MAP SECTION.
      *

           MOVE 'XA-'                  TO WS-PROG-SECT-NAME.
           EXEC CICS
               RECEIVE MAP('EP02MAP')
                       MAPSET('EP02MAP')
                       INTO(EP02MAPI)
                       RESP(WS-EIBRESP)
           END-EXEC.
           EVALUATE WS-EIBRESP
           WHEN DFHRESP(NORMAL)
               SET VALID-DATA TO TRUE
               MOVE COUNTO    TO WS-COUNT
               MOVE DATETIMEO TO WS-DATETIME
               MOVE REPEATYNO TO WS-REPEATYN
           WHEN DFHRESP(MAPFAIL)
               IF WS-COUNT = 0
                  SET INVALID-DATA TO TRUE
                  MOVE WS-COUNT     TO COUNTO
                  MOVE WS-DATETIME  TO DATETIMEO
                  MOVE WS-REPEATYN  TO REPEATYNO
               END-IF
           WHEN OTHER
               PERFORM ZZX-CICS-ERROR-ROUTINE
           END-EVALUATE.

       XA-EXIT.
           EXIT.

      *
       XB-SEND-EP02MAP SECTION.
      *

           MOVE 'XB-'                  TO WS-PROG-SECT-NAME.
           EVALUATE TRUE
           WHEN SEND-ERASE
               IF DEBUG-ON
                   EXEC CICS ENTER TRACEID (2) END-EXEC
               END-IF
               EXEC CICS
                   SEND MAP('EP02MAP')
                        MAPSET('EP02MAP')
                        FROM(EP02MAPO)
                        ERASE
                        FREEKB CURSOR FRSET
               END-EXEC
           WHEN SEND-DATAONLY
               IF DEBUG-ON
                   EXEC CICS ENTER TRACEID (3) END-EXEC
               END-IF
               EXEC CICS
                   SEND MAP('EP02MAP')
                        MAPSET('EP02MAP')
                        FROM(EP02MAPO)
                        DATAONLY
                        FREEKB CURSOR
               END-EXEC
           WHEN SEND-DATAONLY-ALARM
               IF DEBUG-ON
                   EXEC CICS ENTER TRACEID (4) END-EXEC
               END-IF
               EXEC CICS
                   SEND MAP('EP02MAP')
                        MAPSET('EP02MAP')
                        FROM(EP02MAPO)
                        DATAONLY
                        ALARM
                        FREEKB CURSOR
               END-EXEC
           WHEN SEND-CLEAR-SCREEN
               IF DEBUG-ON
                   EXEC CICS ENTER TRACEID (5) END-EXEC
               END-IF
               EXEC CICS
                   SEND MAP('EP02MAP')
                        MAPSET('EP02MAP')
                        ERASE MAPONLY
                        FREEKB CURSOR FRSET
               END-EXEC
           WHEN OTHER
               IF DEBUG-ON
                   EXEC CICS ENTER TRACEID (6) END-EXEC
               END-IF
               EXEC CICS
                   SEND MAP('EP02MAP')
                        MAPSET('EP02MAP')
                        FROM(EP02MAPO)
                        FREEKB CURSOR
               END-EXEC
           END-EVALUATE.

       XB-EXIT.
           EXIT.

      *
       ZZX-CICS-ERROR-ROUTINE SECTION.
      *

           MOVE EIBRESP                     TO WS-EIBRESP-DISP.
           MOVE WS-EIBRESP-DISP             TO MSG-CICS-RESP(1).
           MOVE EIBRESP2                    TO WS-EIBRESP-DISP.
           MOVE WS-EIBRESP-DISP             TO MSG-CICS-RESP(2).
           EXEC CICS
               SEND
               ERASE
               FROM(MSG-CICS-RESPONSE-CODES)
               LENGTH(LENGTH OF MSG-CICS-RESPONSE-CODES)
           END-EXEC.
           EXEC CICS RETURN END-EXEC.
           GOBACK.

       ZZX-EXIT.
           EXIT.
           EJECT
      *end of program
