      *
      * Module Name        EP01.CCP
      *
      * Descriptive Name   CICS External Presentation Interface
      *
      * Statement:         Licensed Materials - Property of IBM
      *
      *                    5724-D12
      *                    (c) Copyright IBM Corporation 1999, 2002
      *
      *                    See Copyright Instructions.
      *
      *                    All rights reserved.
      *
      *                    U.S. Government Users Restricted Rights -
      *                    use duplication or disclosure restricted by
      *                    GSA ADP Schedule Contract with IBM Corp.
      *
      * Status:            Version 5 Release 1
      * Notes :-
      *
      * EP01 is a Basic CICS Server Cobol sample program which is used
      * with the frontend sample programs to demonstrate the use of
      * External Presentation Interface (EPI).
      *
      * The following code is sample code created by IBM Corporation.
      * This sample code is not part of any standard IBM product and
      * is provided to you solely for the purpose of assisting you in
      * the development of your applications. The code is provided 'as
      * is', without warranty or condition of any kind.  IBM shall not
      * be liable for any damages arising out of your use of the
      * sample code, even if IBM has been advised of the possibility
      * of such damages.
      *
      * Sample Output:
      *
      * To unit test this program use transaction EP01 as follows:
      *                                   Output from CICS terminal:
      *
      * First run                     -> 'EP01        1st run OF EP01'
      * Press enter                   -> 'EP01        2nd run OF EP01'
      * Press enter                   -> 'EP01        3rd run OF EP01'
      * etc                               etc
      * Press enter                   -> 'EP01       12th run OF EP01'
      * etc                               etc
      * Press any key other than enter to exit.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. EP01.

       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      * Working storage starts here
      *
       01  FILLER                            PIC X(32)  VALUE
           '** Working storage starts here**'.

      *
      * This WS area contains all woring variables.
      *
       01  FILLER                           PIC X(8)   VALUE 'WS-'.
       01  WS-DEBUG-AREA.
           05 WS-PROG-NAME                  PIC X(16) VALUE SPACES.
           05 WS-TRANSID                    PIC X(04) VALUE SPACES.
           05 WS-PROG-SECT-NAME             PIC X(32) VALUE SPACES.
           05 WS-IN-EIBCALEN                PIC 9(8) COMP VALUE 80.
           05 WS-EIBRESP-DISP               PIC S9(9)
              SIGN LEADING SEPARATE.
           05  WS-DEBUG-ON-FLAG             PIC X VALUE 'Y'.
               88  DEBUG-ON                 VALUE 'Y'.

       01  MSG-FIELDS.
           05  MSG-1                        PIC X(80) VALUE SPACES.
           05  MSG-TIMES.
               10  MSG-COUNT                PIC Z(8)9 VALUE '        1'.
               10  MSG-COUNT-SUFFIX         PIC X(02) VALUE 'st'.
               10  FILLER                   PIC X(69)
                                            VALUE ' run OF EP01'.
           05  MSG-CICS-RESPONSE-CODES.
               10  FILLER                   PIC X(20) VALUE
                                            'EIBRESP & EIBRESP2: '.
               10 MSG-CICS-RESP             OCCURS 2 TIMES
                                            PIC X(10).
               10  FILLER                   PIC X(40) VALUE SPACES.

       01  WS-WORK-FIELDS.
           05  WS-COUNT                     PIC  9(9).
           05  WS-COUNTO REDEFINES WS-COUNT.
               10  WS-COUNTO-CHAR PIC X OCCURS 9.
           05  WS-IDX                       PIC  9(2) VALUE 9.

       01  OUTBOUND-DATA.
           05  OUT-TRANSACTION-CODE         PIC X(4) VALUE 'EP01'.
           05  OUT-MESSAGE.
               10  OUT-COUNT                PIC 9(9).
               10  FILLER                   PIC X(71).
       01  INBOUND-DATA.
           05  IN-TRANSACTION-CODE          PIC X(4).
           05  IN-MESSAGE.
               10  IN-COUNT                 PIC 9(9).
               10  IN-COUNTI REDEFINES IN-COUNT.
                   15  IN-COUNTI-CHAR PIC X OCCURS 9.
               10  FILLER                   PIC X(71).

       01  CONV-POINTER                     POINTER.

       COPY DFHAID.

      *
       LINKAGE SECTION.
      *
       01 THE-COMMAREA.
          03 RUN-COUNTER          PIC 9(04).


      *
       PROCEDURE DIVISION.
      *
       A-CONTROL SECTION.

           MOVE 'EP01'                 TO WS-PROG-NAME.
           MOVE 'EP01'                 TO WS-TRANSID.
           MOVE 'A-'                   TO WS-PROG-SECT-NAME.
           IF DEBUG-ON
               EXEC CICS HANDLE CONDITION ERROR (ZZX-CICS-ERROR-ROUTINE)
                         END-EXEC
           END-IF.
           PERFORM B-RECEIVE-INITIAL-DATA.

           IF EIBAID NOT = DFHENTER
             EXEC CICS RETURN END-EXEC
           END-IF.

           ADD  1             TO RUN-COUNTER.
           MOVE RUN-COUNTER   TO WS-COUNT.

           MOVE WS-COUNT TO MSG-COUNT.
           EVALUATE WS-COUNTO-CHAR(9) ALSO WS-COUNTO-CHAR (8)
           WHEN '1' ALSO NOT '1'
               MOVE 'st' TO MSG-COUNT-SUFFIX
           WHEN '2' ALSO NOT '1'
               MOVE 'nd' TO MSG-COUNT-SUFFIX
           WHEN '3' ALSO NOT '1'
               MOVE 'rd' TO MSG-COUNT-SUFFIX
           WHEN OTHER
               MOVE 'th' TO MSG-COUNT-SUFFIX
           END-EVALUATE.

           MOVE MSG-TIMES TO OUT-MESSAGE.

           PERFORM C-SEND-MSG-TO-CLIENT.

           EXEC CICS RETURN
             TRANSID(WS-TRANSID)
             COMMAREA(THE-COMMAREA)
             LENGTH(LENGTH OF THE-COMMAREA)
           END-EXEC.

           GOBACK.
       A-END.
           EXIT.

      *
      *  Receive commarea passed from client with EpiStartTran or   
      *  use working storage.
      *  Run counter is in the first 4 bytes, display message       
      *  on the Message Log.                                        
      *
       B-RECEIVE-INITIAL-DATA SECTION.
       B1.
           EXEC CICS
               RECEIVE
               INTO(INBOUND-DATA)
               LENGTH(LENGTH OF INBOUND-DATA)
           END-EXEC.

           IF EIBCALEN = ZERO
             EXEC CICS
               GETMAIN
               SET(CONV-POINTER)
               FLENGTH(LENGTH OF THE-COMMAREA)
             END-EXEC
             SET ADDRESS OF THE-COMMAREA TO CONV-POINTER
             MOVE 0 TO RUN-COUNTER
           ELSE
             EXEC CICS
               ADDRESS COMMAREA(CONV-POINTER)
             END-EXEC
             SET ADDRESS OF THE-COMMAREA TO CONV-POINTER
           END-IF.


       B-END.
           EXIT.

      *
      * Sends our message back to the client.                       
      *
       C-SEND-MSG-TO-CLIENT SECTION.
       C1.
           EXEC CICS
                SEND
                ERASE
                FROM(OUTBOUND-DATA)
                LENGTH(LENGTH OF OUTBOUND-DATA)
           END-EXEC.
       C-END.
           EXIT.

      *
       ZZX-CICS-ERROR-ROUTINE SECTION.
      *

           MOVE EIBRESP                     TO WS-EIBRESP-DISP.
           MOVE WS-EIBRESP-DISP             TO MSG-CICS-RESP(1).
           MOVE EIBRESP2                    TO WS-EIBRESP-DISP.
           MOVE WS-EIBRESP-DISP             TO MSG-CICS-RESP(2).
           MOVE MSG-CICS-RESPONSE-CODES     TO MSG-1.
           EXEC CICS
               SEND
               ERASE
               FROM(MSG-1)
               LENGTH(LENGTH OF MSG-1)
           END-EXEC
           EXEC CICS
               RETURN
           END-EXEC.
           GOBACK.

       ZZX-EXIT.
           EXIT.
           EJECT
      *End of program
