      *
      * Module Name        EC02.CCP                                    
      *                                                                
      * Descriptive Name   CICS External Call Interface                
      *                                                                
      * Statement:         Licensed Materials - Property of IBM
      *                                                                
      *                    5724-D12                                    
      *                    (c) Copyright IBM Corporation 1999, 2002    
      *                                                                
      *                    See Copyright Instructions.                 
      *                                                                
      *                    All rights reserved.                        
      *                                                                
      *                    U.S. Government Users Restricted Rights -   
      *                    use duplication or disclosure restricted by 
      *                    GSA ADP Schedule Contract with IBM Corp.    
      *                                                                
      * Status:            Version 5 Release 1                         
      * Notes :-                                                       
      *                                                                
      * This server program increments and returns the run number.     
      *                                                                
      * EC02 is a Basic CICS Server Cobol sample program which is used
      * with the frontend sample programs to demonstrate the use of    
      * External Call Interface (ECI).                                 
      *                                                                
      * The following code is sample code created by IBM Corporation.  
      * This sample code is not part of any standard IBM product and   
      * is provided to you solely for the purpose of assisting you in  
      * the development of your applications.  The code is provided    
      * 'as is', without warranty or condition of any kind.  IBM shall 
      * not be liable for any damages arising out of your use of the   
      * sample code, even if IBM has been advised of the possibility   
      * of such damages. 
      *                                              
      * Sample Output:                                                 
      *                                                   
      * To unit test this program use CECI as follows:                 
      * LINK PROG(EC02) COMMAREA('000001234th run of EC02') LEN(40)    
      *                                                                
      * CECI returns:                                                  
      *                                                    
      * LINK PROG(EC02) COMMAREA('000001234TH RUN OF EC02') LEN(40)    
      * STATUS:  COMMAND EXECUTION COMPLETE                      NAME= 
      *  EXEC CICS  LInk Program( 'EC02    ' )                         
      *   < Commarea( '     1235th run OF EC02                .' )     
      *     < Length( +00040 ) > < Datalength() > >                    
      *   < SYSid() >                                                  
      *   < SYNconreturn >                                             
      *   < Transid() >                                                
      *   < INPUTMSG() < INPUTMSGLen() > >                             
      *                                                                
      *  RESPONSE: NORMAL              EIBRESP=+0000000000 EIBRESP2=+0 
      * F 1 HELP 2 HEX 3 END 4 EIB 5 VAR 6 USER 7 SBH 8 SFH 9 MSG 10 S 
      *                                                                

       IDENTIFICATION DIVISION.
       PROGRAM-ID. EC02.

       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      * WORKING STORAGE STARTS HERE                                   
      *
       01  FILLER                            PIC X(32)  VALUE
           '** Working storage starts here**'.

      *
      * This WS area contains all switches and flags.                 
      *
       01  FILLER                           PIC X(8)   VALUE 'WS-'.
       01  WS-DEBUG-AREA.
           05 WS-PROG-NAME                  PIC X(16) VALUE SPACES.
           05 WS-PROG-SECT-NAME             PIC X(32) VALUE SPACES.
           05 WS-EIBRESP-DISP               PIC S9(9)
              SIGN LEADING SEPARATE.
           05  WS-DEBUG-ON-FLAG             PIC X VALUE 'Y'.
               88  DEBUG-ON                 VALUE 'Y'.

       01  MSG-FIELDS.
           05  MSG-1                        PIC X(95) VALUE SPACES.

           05  MSG-TIMES.
               10  MSG-COUNT                PIC Z(8)9 VALUE '        1'.
               10  MSG-COUNT-SUFFIX         PIC X(02) VALUE 'st'.
               10  FILLER                   PIC X(29)
                                            VALUE ' run OF EC02'.

       01  WS-WORK-FIELDS.
           05  WS-COUNT                     PIC  9(9).
           05  WS-COUNTO REDEFINES WS-COUNT.
               10  WS-COUNTO-CHAR PIC X OCCURS 9.
           05  WS-IDX                       PIC  9(2) VALUE 9.

      *
       LINKAGE SECTION.
      *
       01  DFHCOMMAREA.
           05  LK-COUNT                     PIC 9(9).
           05  LK-COUNTI REDEFINES LK-COUNT.
               10  LK-COUNTI-CHAR PIC X OCCURS 9.
           05  FILLER                       PIC X(30).
           05  LK-LOWVAL                    PIC X(01).


      *
       PROCEDURE DIVISION.
      *
      * This server program increments and returns the run number.   *
       A-CONTROL SECTION.

           MOVE 'EC02'                 TO WS-PROG-NAME.
           MOVE 'A-'                   TO WS-PROG-SECT-NAME.
           IF DEBUG-ON
               EXEC CICS HANDLE CONDITION ERROR (ZZX-CICS-ERROR-ROUTINE)
                     END-EXEC
           END-IF.

           IF EIBCALEN < LENGTH OF DFHCOMMAREA
           THEN
               PERFORM ZZX-CICS-ERROR-ROUTINE
           END-IF.

           IF LK-COUNTI-CHAR (9) NUMERIC
           THEN
               PERFORM VARYING WS-IDX
                   FROM 9 BY -1 UNTIL WS-IDX EQUAL ZERO
                   IF LK-COUNTI-CHAR (WS-IDX) NOT NUMERIC
                   THEN
                       MOVE 0 TO LK-COUNTI-CHAR(WS-IDX)
                   END-IF
               END-PERFORM
               MOVE LK-COUNT  TO MSG-COUNT
                                 WS-COUNT
           ELSE
               MOVE 0         TO WS-COUNT
           END-IF.
           IF (EIBCALEN = 0) OR (WS-COUNT NOT NUMERIC)
           THEN
               MOVE 1         TO WS-COUNT
           ELSE
               ADD  1         TO WS-COUNT
           END-IF.

           MOVE WS-COUNT TO MSG-COUNT.
           EVALUATE WS-COUNTO-CHAR (9) ALSO WS-COUNTO-CHAR (8)
           WHEN '1' ALSO NOT '1'
               MOVE 'st' TO MSG-COUNT-SUFFIX
           WHEN '2' ALSO NOT '1'
               MOVE 'nd' TO MSG-COUNT-SUFFIX
           WHEN '3' ALSO NOT '1'
               MOVE 'rd' TO MSG-COUNT-SUFFIX
           WHEN OTHER
               MOVE 'th' TO MSG-COUNT-SUFFIX
           END-EVALUATE.

           MOVE MSG-TIMES  TO DFHCOMMAREA.

           MOVE LOW-VALUES TO LK-LOWVAL.
           EXEC CICS RETURN END-EXEC.
           GOBACK.
      *
       A-EXIT.
           EXIT.
           EJECT

      *
       ZZX-CICS-ERROR-ROUTINE SECTION.
      *

           IF EIBCALEN < LENGTH OF DFHCOMMAREA
           THEN
             EXEC CICS
                 ABEND
                 ABCODE('ECOM')
             END-EXEC
           ELSE
             EXEC CICS
                 ABEND
                 ABCODE('ERRO')
             END-EXEC
           END-IF.
           GOBACK.

       ZZX-EXIT.
           EXIT.
           EJECT

      *end of program
