      *                                                                
      * Module Name        EC01.CCP                                    
      *                                                                
      * Descriptive Name   CICS External Call Interface                
      *                                                                
      * Statement:         Licensed Materials - Property of IBM        
      *                                                                
      *                    5724-D12                                    
      *                    (c) Copyright IBM Corporation 1999, 2002    
      *                                                                
      *                    See Copyright Instructions.                 
      *                                                                
      *                    All rights reserved.                        
      *                                                                
      *                    U.S. Government Users Restricted Rights -   
      *                    use duplication or disclosure restricted by 
      *                    GSA ADP Schedule Contract with IBM Corp.    
      *                                                                
      * Status:            Version 5 Release 1                         
      * Notes :-                                                       
      *                                                                
      * This server program returns the date and time.                 
      *                                                                
      * EC01 is a Basic CICS Server Cobol sample program which is used 
      * with the frontend sample programs to demonstrate the use of    
      * External Call Interface (ECI).                                 
      *                                                                
      * The following code is sample code created by IBM Corporation.  
      * This sample code is not part of any standard IBM product and   
      * is provided to you solely for the purpose of assisting you in  
      * the development of your applications.  The code is provided    
      * 'as is', without warranty or condition of any kind.  IBM shall 
      * not be liable for any damages arising out of your use of the   
      * sample code, even if IBM has been advised of the possibility   
      * of such damages.                                               
      *
      * Sample Output:                                                 
      *                                                   
      * To unit test this program use CECI as follows:                 
      * LINK PROG(EC01) COMMAREA(' ') LEN(18)                          
      *                                                                
      * CECI returns:                                                  
      *                                                    
      * LI PR(EC01) COM(' ') LEN(18)                                   
      * STATUS:  COMMAND EXECUTION COMPLETE                      NAME= 
      *  EXEC CICS  LInk Program( 'EC01    ' )                         
      *   < Commarea( '06/09/99 12:07:55.' ) < Length( +00018 ) > < Da 
      *   < SYSid() >                                                  
      *   < SYNconreturn >                                             
      *   < Transid() >                                                
      *   < INPUTMSG() < INPUTMSGLen() > >                             
      *                                                                
      *  RESPONSE: NORMAL              EIBRESP=+0000000000 EIBRESP2=+0 
      * F 1 HELP 2 HEX 3 END 4 EIB 5 VAR 6 USER 7 SBH 8 SFH 9 MSG 10 S 
      *                                                                
      *

       IDENTIFICATION DIVISION.
       PROGRAM-ID. EC01.

       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      * Working storage starts here                                   
       01  FILLER                            PIC X(32)  VALUE
           '** Working storage starts here**'.

      * This WS area contains all working variables.                  
       01  FILLER                           PIC X(8)   VALUE 'WS-'.
       01  WS-DEBUG-AREA.
           05  WS-RAWTIME                  PIC S9(15) COMP-3.
           05  WS-DATE-DEBUG-AREA          PIC X(8).
           05  WS-TIME-DEBUG-AREA          PIC X(8).
           05  WS-EIBRESP-DISP             PIC S9(9)
               SIGN LEADING SEPARATE.
           05  WS-CICS-RESP                OCCURS 2 TIMES
                                           PIC X(10).
           05  WS-DEBUG-ON-FLAG             PIC X VALUE 'Y'.
               88  DEBUG-ON                 VALUE 'Y'.


      *
       LINKAGE SECTION.
      *
       01  DFHCOMMAREA.
           05  LK-DATE-OUT      PIC X(8).
           05  LK-SPACE-OUT     PIC X(1).
           05  LK-TIME-OUT      PIC X(8).
           05  LK-LOWVAL-OUT    PIC X(1).

      *
       PROCEDURE DIVISION.
      *
       A-CONTROL SECTION.

           IF DEBUG-ON
              EXEC CICS HANDLE CONDITION ERROR (ZZX-CICS-ERROR-ROUTINE)
                         END-EXEC
           END-IF.

           IF EIBCALEN < LENGTH OF DFHCOMMAREA
           THEN
               PERFORM ZZX-CICS-ERROR-ROUTINE
           END-IF.

           MOVE SPACES TO DFHCOMMAREA.

           EXEC CICS
               ASKTIME ABSTIME(WS-RAWTIME)
           END-EXEC.

           EXEC CICS
               FORMATTIME ABSTIME(WS-RAWTIME)
                          DDMMYY(LK-DATE-OUT)
                          DATESEP('/')
                          TIME(LK-TIME-OUT)
                          TIMESEP(':')
           END-EXEC.
           MOVE LOW-VALUES  TO LK-LOWVAL-OUT.

           MOVE LK-DATE-OUT TO WS-DATE-DEBUG-AREA.
           MOVE LK-TIME-OUT TO WS-TIME-DEBUG-AREA.

           EXEC CICS RETURN END-EXEC.

           GOBACK.

      *
       ZZX-CICS-ERROR-ROUTINE SECTION.
      *

           IF EIBCALEN < LENGTH OF DFHCOMMAREA
           THEN
             EXEC CICS
                 ABEND
                 ABCODE('ECOM')
             END-EXEC
           ELSE
             EXEC CICS
                 ABEND
                 ABCODE('ERRO')
             END-EXEC
           END-IF.
           GOBACK.

       ZZX-EXIT.
           EXIT.
           EJECT
      *end of program
