      * ----------------------------------------------------------------
      * Employee Detail Re-engineered Server.
      * Copyright IBM 2005.
      * ---------------------------------------------
      * Generated:   Tue Mar 29 16:52:17 PST 2005
      * Name:        RTEMPLOY
      * Description:
      * CICS ECI Router program.
      * ----------------------------------------------------------------

        IDENTIFICATION DIVISION.

        PROGRAM-ID. RTEMPLOY.

        ENVIRONMENT DIVISION.
R
        DATA DIVISION.

          WORKING-STORAGE SECTION.
      * ----------------------------------------------------------------
      * View(s) associated with CASHR-USER-PROFL-DEL (RCUPD01).
      * ----------------------------------------------------------------
        01 CASHR-USER-PROFL-DEL-I.
           COPY VCUPDI01.
        01 CASHR-USER-PROFL-DEL-O.
           COPY VCUPDO02.
      * ----------------------------------------------------------------
      * View(s) associated with SECURITY-ACCESS-VRFY (ADDVMU).
      * ----------------------------------------------------------------
        01 SECURITY-ACCESS-VRFY-I.
           COPY ZADDWMU.
        01 SECURITY-ACCESS-VRFY-O.
           COPY ZADDXMU.
      * ----------------------------------------------------------------
      * View(s) associated with CASHR-USER-PROFL-READ (RCUPR01).
      * ----------------------------------------------------------------
        01 CASHR-USER-PROFL-READ-I.
           COPY VCUPRI01.
        01 CASHR-USER-PROFL-READ-O.
           COPY VCUPRO01.
      * ----------------------------------------------------------------
      * View(s) associated with CASHR-ORG-PROFL-READ-DRVR (RCOPRD1).
      * ----------------------------------------------------------------
        01 CASHR-ORG-PROFL-READ-DRVR-I.
           COPY VCOPRDI1.
        01 CASHR-ORG-PROFL-READ-DRVR-O.
           COPY VCOPRDO1.
      * ----------------------------------------------------------------
      * View(s) associated with CASHR-USER-PROFL-UPDT (RCUPU01).
      * ----------------------------------------------------------------
        01 CASHR-USER-PROFL-UPDT-I.
           COPY VCUPUI01.
        01 CASHR-USER-PROFL-UPDT-O.
           COPY VCUPUO01.
      * ----------------------------------------------------------------
      * View(s) associated with CASHR-USER-PROFL-ADD (RCUPA01).
      * ----------------------------------------------------------------
        01 CASHR-USER-PROFL-ADD-I.
           COPY VCUPAI01.
        01 CASHR-USER-PROFL-ADD-O.
           COPY VCUPAO01.

      * ----------------------------------------------------------------
      * Rule names
      * ----------------------------------------------------------------
        01 CALLED-PROGRAM-NAMES.
           02 CASHR-USER-PROFL-DEL         PIC X(8) VALUE 'RCUPD01'.
           02 SECURITY-ACCESS-VRFY         PIC X(8) VALUE 'ADDVMU'.
           02 CASHR-USER-PROFL-READ        PIC X(8) VALUE 'RCUPR01'.
           02 CASHR-ORG-PROFL-READ-DRVR    PIC X(8) VALUE 'RCOPRD1'.
           02 CASHR-USER-PROFL-UPDT        PIC X(8) VALUE 'RCUPU01'.
           02 CASHR-USER-PROFL-ADD         PIC X(8) VALUE 'RCUPA01'.

      * ----------------------------------------------------------------
      * Sundry variables
      * ----------------------------------------------------------------
        01 OUTPUT-DATA-LENGTH              PIC S9(8) BINARY.
        01 INPUT-DATA-LENGTH               PIC S9(8) BINARY.
        01 MESSAGE-POS                     PIC 9(8) COMP VALUE IS 1.
        01 LOOP-INDEX-1                    PIC S9(9) COMP.
        01 LOOP-INDEX-2                    PIC S9(9) COMP.
        01 LOOP-INDEX-3                    PIC S9(9) COMP.

      * ----------------------------------------------------------------
      * Definition of Router Return Codes
      * ----------------------------------------------------------------
        77 R2C-OK                          PIC X(3) VALUE '000'.
        77 R2C-BAD-RULE-NAME               PIC X(3) VALUE '001'.
        77 R2C-NO-MORE-DATA                PIC X(3) VALUE '002'.
        77 R2C-BAD-INPUT                   PIC X(3) VALUE '003'.
        77 R2C-BAD-HEADER                  PIC X(3) VALUE '004'.
        77 R2C-BAD-LENGTH-IN               PIC X(3) VALUE '005'.
        77 R2C-DATA-TOO-LARGE              PIC X(3) VALUE '006'.
        77 R2C-UNKNOWN-ERROR               PIC X(3) VALUE '999'.

      * ----------------------------------------------------------------
      * Intermediate variables used in marshalling routines
      * ----------------------------------------------------------------
        01 MARSHALL-VARIABLES.
           02 CHAR-19                      PIC X(19).
           02 IBM-SMALLINT                 REDEFINES CHAR-19.
            03 IBM-SMALLINT-NUM            PIC S9(5) LEADING SEPARATE.
            03 FILLER                      PIC X(13).
           02 IBM-INTEGER                  REDEFINES CHAR-19.
            03 IBM-INTEGER-NUM             PIC S9(10) LEADING SEPARATE.
            03 FILLER                      PIC X(8).
           02 IBM-DEC-15-2                 REDEFINES CHAR-19.
            03 IBM-DEC-15-2-NUM
                  PIC S9(13)V99 LEADING SEPARATE.
            03 FILLER                      PIC X(3).

          LINKAGE SECTION.
      * ----------------------------------------------------------------
      * Commarea layout.
      * ----------------------------------------------------------------
        01 DFHCOMMAREA.
           02 COMMAREA-LAYOUT.
            03 COMMAREA-HEADER-IN.
             04 COMMAREA-VERSION-NO        PIC X.
             04 COMMAREA-MESSAGE-TYPE      PIC X.
             04 COMMAREA-MESSAGE-ID        PIC S9(10) LEADING SEPARATE.
             04 COMMAREA-TP-PROGRAM        PIC X(8).
             04 COMMAREA-MAX-LENGTH        PIC 9(10).
             04 COMMAREA-LENGTH-IN         PIC 9(10).
             04 COMMAREA-SEQUENCE          PIC 9(3).
             04 COMMAREA-MORE-FLAG         PIC X.
            03 COMMAREA-HEADER-OUT         REDEFINES COMMAREA-HEADER-IN.
             04 FILLER                     PIC X.
             04 COMMAREA-ERROR-OUT         PIC X(3).
             04 COMMAREA-RESP-OUT          PIC S9(5).
             04 COMMAREA-RESP2-OUT         PIC S9(5).
             04 FILLER                     PIC X(31).
            03 COMMAREA-HEADER-ABEND       REDEFINES COMMAREA-HEADER-IN.
             04 FILLER                     PIC X.
             04 COMMAREA-ERROR-ABEND       PIC X(3).
             04 COMMAREA-CODE-ABEND        PIC X(4).
             04 COMMAREA-CODE2-ABEND       PIC X(6).
             04 FILLER                     PIC X(31).
            03 MESSAGE-BODY                PIC X(32722).

        PROCEDURE DIVISION.

          MAIN-SECTION SECTION.
      * ----------------------------------------------------------------
      * Check the message length.
      * ----------------------------------------------------------------
           IF EIBCALEN < LENGTH OF COMMAREA-HEADER-IN
              MOVE R2C-BAD-HEADER TO COMMAREA-ERROR-OUT
              PERFORM ROUTER-END
           END-IF

           COMPUTE INPUT-DATA-LENGTH =
              EIBCALEN - LENGTH OF COMMAREA-HEADER-IN
      *     IF INPUT-DATA-LENGTH IS NOT = COMMAREA-LENGTH-IN
      *        MOVE R2C-BAD-LENGTH-IN TO COMMAREA-ERROR-OUT
      *        PERFORM ROUTER-END
      *     END-IF

      * ----------------------------------------------------------------
      * Currently we don't support continuation messages.
      * ----------------------------------------------------------------
           IF COMMAREA-MESSAGE-TYPE IS NOT = 'I'
             MOVE R2C-BAD-INPUT TO COMMAREA-ERROR-OUT
             MOVE 'N' TO COMMAREA-MORE-FLAG
             PERFORM ROUTER-END
           END-IF

      * ----------------------------------------------------------------
      * Invoke the appropriate rule
      * ----------------------------------------------------------------
           EVALUATE COMMAREA-TP-PROGRAM
      * ----------------------------------------------------------------
           WHEN CASHR-USER-PROFL-DEL
      *        Extract CASHR-USER-PROFL-DEL-I
               PERFORM UNMARSHALL-VCUPDI01
      *        Invoke RCUPD01
               CALL CASHR-USER-PROFL-DEL USING
                    BY REFERENCE CASHR-USER-PROFL-DEL-I
                    BY REFERENCE CASHR-USER-PROFL-DEL-O
      *        Marshall CASHR-USER-PROFL-DEL-O
               PERFORM MARSHALL-VCUPDO02
      * ----------------------------------------------------------------
           WHEN SECURITY-ACCESS-VRFY
      *        Extract SECURITY-ACCESS-VRFY-I
               PERFORM UNMARSHALL-ZADDWMU
      *        Invoke ADDVMU
               CALL SECURITY-ACCESS-VRFY USING
                    BY REFERENCE SECURITY-ACCESS-VRFY-I
                    BY REFERENCE SECURITY-ACCESS-VRFY-O
      *        Marshall SECURITY-ACCESS-VRFY-O
               PERFORM MARSHALL-ZADDXMU
      * ----------------------------------------------------------------
           WHEN CASHR-USER-PROFL-READ
      *        Extract CASHR-USER-PROFL-READ-I
               PERFORM UNMARSHALL-VCUPRI01
      *        Invoke RCUPR01
               CALL CASHR-USER-PROFL-READ USING
                    BY REFERENCE CASHR-USER-PROFL-READ-I
                    BY REFERENCE CASHR-USER-PROFL-READ-O
      *        Marshall CASHR-USER-PROFL-READ-O
               PERFORM MARSHALL-VCUPRO01
      * ----------------------------------------------------------------
           WHEN CASHR-ORG-PROFL-READ-DRVR
      *        Extract CASHR-ORG-PROFL-READ-DRVR-I
               PERFORM UNMARSHALL-VCOPRDI1
      *        Invoke RCOPRD1
               CALL CASHR-ORG-PROFL-READ-DRVR USING
                    BY REFERENCE CASHR-ORG-PROFL-READ-DRVR-I
                    BY REFERENCE CASHR-ORG-PROFL-READ-DRVR-O
      *        Marshall CASHR-ORG-PROFL-READ-DRVR-O
               PERFORM MARSHALL-VCOPRDO1
      * ----------------------------------------------------------------
           WHEN CASHR-USER-PROFL-UPDT
      *        Extract CASHR-USER-PROFL-UPDT-I
               PERFORM UNMARSHALL-VCUPUI01
      *        Invoke RCUPU01
               CALL CASHR-USER-PROFL-UPDT USING
                    BY REFERENCE CASHR-USER-PROFL-UPDT-I
                    BY REFERENCE CASHR-USER-PROFL-UPDT-O
      *        Marshall CASHR-USER-PROFL-UPDT-O
               PERFORM MARSHALL-VCUPUO01
      * ----------------------------------------------------------------
           WHEN CASHR-USER-PROFL-ADD
      *        Extract CASHR-USER-PROFL-ADD-I
               PERFORM UNMARSHALL-VCUPAI01
      *        Invoke RCUPA01
               CALL CASHR-USER-PROFL-ADD USING
                    BY REFERENCE CASHR-USER-PROFL-ADD-I
                    BY REFERENCE CASHR-USER-PROFL-ADD-O
      *        Marshall CASHR-USER-PROFL-ADD-O
               PERFORM MARSHALL-VCUPAO01
      * ----------------------------------------------------------------
           WHEN OTHER
      *        The rule is not known to this program
               MOVE R2C-BAD-RULE-NAME TO COMMAREA-ERROR-OUT
               PERFORM ROUTER-END
           END-EVALUATE

      * ----------------------------------------------------------------
      * Set up COMMAREA for return.
      * ----------------------------------------------------------------
           MOVE R2C-OK TO COMMAREA-ERROR-OUT
           MOVE 'N' TO COMMAREA-MORE-FLAG
           .
      * ----------------------------------------------------------------
      * Return.
      * ----------------------------------------------------------------
       ROUTER-END.
           EXEC CICS
                RETURN
           END-EXEC.

       HAPPY-COMPILER-GOBACK.
      *    Keep the compiler happy.
           GOBACK.
      * ----------------------------------------------------------------
      * Routines for marshalling and unmarshalling view(s) associated
      * with CASHR-USER-PROFL-DEL (RCUPD01).
      * ----------------------------------------------------------------
      * ----------------------------------------------------------------
      * Unmarshall CASHR-USER-PROFL-DEL-I
      * ----------------------------------------------------------------
          UNMARSHALL-VCUPDI01 SECTION.
           MOVE 1 TO MESSAGE-POS
           INITIALIZE CASHR-USER-PROFL-DEL-I
      *    Unmarshall subrecord CASHR-USER-PROFL
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO CASHR-TRAN-RLOV-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SWB-ORG-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall VARCHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO PRINT-DSTN-ID-LEN
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO PRINT-DSTN-ID
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall INTEGER
           MOVE MESSAGE-BODY(MESSAGE-POS:11) TO IBM-INTEGER
           MOVE IBM-INTEGER-NUM
                TO CUT-OFF-TM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO IN-STATE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO REDEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO AR-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO CASHR-TRAN-FEE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall INTEGER
           MOVE MESSAGE-BODY(MESSAGE-POS:11) TO IBM-INTEGER
           MOVE IBM-INTEGER-NUM
                TO CASHR-TRAN-POST-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO CHECK-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall SMALLINT
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO DEP-CNTRB-YEAR-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO FUND-MED-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO LATE-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO EMP-USER-ID
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall CHAR(15)
           MOVE MESSAGE-BODY(MESSAGE-POS:15)
                TO TOA-CONTRA-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 15
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO FUND-RQST-CRNCY-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO KEO-NON-DED-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall DEC(15, 2)
           MOVE MESSAGE-BODY(MESSAGE-POS:16) TO IBM-DEC-15-2
           MOVE IBM-DEC-15-2-NUM
                TO CASHR-TRAN-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO TOA-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall DEC(15, 2)
           MOVE MESSAGE-BODY(MESSAGE-POS:16) TO IBM-DEC-15-2
           MOVE IBM-DEC-15-2-NUM
                TO FUND-RQST-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO FUND-RQST-SRCE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-FIRST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-MIDL-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-LAST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-NM-SUFF
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-NM-TITLE
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO USER-PHON-AREA-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO USER-PHON-PRFX-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO USER-PHON-LINE-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-PHON-EXT-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO USER-SEC-LEVEL-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall SMALLINT
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO AUDIT-INTG-CNTL-NR
                IN CASHR-USER-PROFL-DEL-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           .

      * ----------------------------------------------------------------
      * Marshall CASHR-USER-PROFL-DEL-O
      * ----------------------------------------------------------------
          MARSHALL-VCUPDO02 SECTION.
           MOVE 1 TO MESSAGE-POS
      *    Marshall subrecord STD-RTRN-DATA
      *    Marshall SMALLINT
           MOVE EXEC-STAT-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-DEL-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(7)
           MOVE MODUL-ID IN STD-RTRN-DATA IN CASHR-USER-PROFL-DEL-O
                TO MESSAGE-BODY(MESSAGE-POS:7)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 7
      *    Marshall SMALLINT
           MOVE MODUL-LOC-NR IN STD-RTRN-DATA IN CASHR-USER-PROFL-DEL-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall INTEGER
           MOVE RTRN-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-DEL-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11.



      * ----------------------------------------------------------------
      * Routines for marshalling and unmarshalling view(s) associated
      * with SECURITY-ACCESS-VRFY (ADDVMU).
      * ----------------------------------------------------------------
      * ----------------------------------------------------------------
      * Unmarshall SECURITY-ACCESS-VRFY-I
      * ----------------------------------------------------------------
          UNMARSHALL-ZADDWMU SECTION.
           MOVE 1 TO MESSAGE-POS
           INITIALIZE SECURITY-ACCESS-VRFY-I
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SPA-RES-CLASS-CD
                IN SECURITY-ACCESS-VRFY-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SPA-RES-NM
                IN SECURITY-ACCESS-VRFY-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SPA-PPG-NM
                IN SECURITY-ACCESS-VRFY-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SPA-ACC-LEVEL-CD
                IN SECURITY-ACCESS-VRFY-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
           .

      * ----------------------------------------------------------------
      * Marshall SECURITY-ACCESS-VRFY-O
      * ----------------------------------------------------------------
          MARSHALL-ZADDXMU SECTION.
           MOVE 1 TO MESSAGE-POS
      *    Marshall subrecord STD-RTRN-DATA
      *    Marshall SMALLINT
           MOVE EXEC-STAT-CD IN STD-RTRN-DATA IN SECURITY-ACCESS-VRFY-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(7)
           MOVE MODUL-ID IN STD-RTRN-DATA IN SECURITY-ACCESS-VRFY-O
                TO MESSAGE-BODY(MESSAGE-POS:7)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 7
      *    Marshall SMALLINT
           MOVE MODUL-LOC-NR IN STD-RTRN-DATA IN SECURITY-ACCESS-VRFY-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall INTEGER
           MOVE RTRN-CD IN STD-RTRN-DATA IN SECURITY-ACCESS-VRFY-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11.



      * ----------------------------------------------------------------
      * Routines for marshalling and unmarshalling view(s) associated
      * with CASHR-USER-PROFL-READ (RCUPR01).
      * ----------------------------------------------------------------
      * ----------------------------------------------------------------
      * Unmarshall CASHR-USER-PROFL-READ-I
      * ----------------------------------------------------------------
          UNMARSHALL-VCUPRI01 SECTION.
           MOVE 1 TO MESSAGE-POS
           INITIALIZE CASHR-USER-PROFL-READ-I
      *    Unmarshall subrecord CASHR-USER-PROFL-PK
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO EMP-USER-ID
                IN CASHR-USER-PROFL-PK
                IN CASHR-USER-PROFL-READ-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
           .

      * ----------------------------------------------------------------
      * Marshall CASHR-USER-PROFL-READ-O
      * ----------------------------------------------------------------
          MARSHALL-VCUPRO01 SECTION.
           MOVE 1 TO MESSAGE-POS
      *    Marshall subrecord STD-RTRN-DATA
      *    Marshall SMALLINT
           MOVE EXEC-STAT-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-READ-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(7)
           MOVE MODUL-ID IN STD-RTRN-DATA IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:7)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 7
      *    Marshall SMALLINT
           MOVE MODUL-LOC-NR IN STD-RTRN-DATA IN CASHR-USER-PROFL-READ-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall INTEGER
           MOVE RTRN-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-READ-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall subrecord CASHR-USER-PROFL
      *    Marshall CHAR(1)
           MOVE CASHR-TRAN-RLOV-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall CHAR(8)
           MOVE SWB-ORG-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall VARCHAR(8)
           MOVE PRINT-DSTN-ID-LEN
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           MOVE PRINT-DSTN-ID
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall INTEGER
           MOVE CUT-OFF-TM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall CHAR(1)
           MOVE IN-STATE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall CHAR(1)
           MOVE REDEP-IN IN CASHR-USER-PROFL IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall CHAR(1)
           MOVE AR-DEP-IN IN CASHR-USER-PROFL IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall CHAR(1)
           MOVE CASHR-TRAN-FEE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall INTEGER
           MOVE CASHR-TRAN-POST-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall CHAR(4)
           MOVE CHECK-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall SMALLINT
           MOVE DEP-CNTRB-YEAR-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(1)
           MOVE FUND-MED-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall CHAR(1)
           MOVE LATE-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall CHAR(8)
           MOVE EMP-USER-ID
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall CHAR(15)
           MOVE TOA-CONTRA-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:15)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 15
      *    Marshall CHAR(3)
           MOVE FUND-RQST-CRNCY-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(1)
           MOVE KEO-NON-DED-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall DEC(15, 2)
           MOVE CASHR-TRAN-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO IBM-DEC-15-2-NUM
           MOVE IBM-DEC-15-2 TO MESSAGE-BODY(MESSAGE-POS:16)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Marshall CHAR(1)
           MOVE TOA-IN IN CASHR-USER-PROFL IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:1)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Marshall DEC(15, 2)
           MOVE FUND-RQST-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO IBM-DEC-15-2-NUM
           MOVE IBM-DEC-15-2 TO MESSAGE-BODY(MESSAGE-POS:16)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Marshall CHAR(4)
           MOVE FUND-RQST-SRCE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall CHAR(30)
           MOVE USER-FIRST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:30)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Marshall CHAR(30)
           MOVE USER-MIDL-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:30)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Marshall CHAR(30)
           MOVE USER-LAST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:30)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Marshall CHAR(5)
           MOVE USER-NM-SUFF
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:5)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Marshall CHAR(5)
           MOVE USER-NM-TITLE
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:5)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Marshall CHAR(3)
           MOVE USER-PHON-AREA-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(3)
           MOVE USER-PHON-PRFX-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(4)
           MOVE USER-PHON-LINE-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall CHAR(5)
           MOVE USER-PHON-EXT-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:5)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Marshall CHAR(4)
           MOVE USER-SEC-LEVEL-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall INTEGER
           MOVE CURR-DT IN CASHR-USER-PROFL-READ-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall subrecord AUDIT-DATA
      *    Marshall INTEGER
           MOVE AUDIT-UPDT-DT IN AUDIT-DATA IN CASHR-USER-PROFL-READ-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall INTEGER
           MOVE AUDIT-UPDT-TM IN AUDIT-DATA IN CASHR-USER-PROFL-READ-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall CHAR(17)
           MOVE AUDIT-USER-ID IN AUDIT-DATA IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:17)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 17
      *    Marshall CHAR(16)
           MOVE AUDIT-PWS-ID IN AUDIT-DATA IN CASHR-USER-PROFL-READ-O
                TO MESSAGE-BODY(MESSAGE-POS:16)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Marshall SMALLINT
           MOVE AUDIT-INTG-CNTL-NR IN CASHR-USER-PROFL-READ-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6.



      * ----------------------------------------------------------------
      * Routines for marshalling and unmarshalling view(s) associated
      * with CASHR-ORG-PROFL-READ-DRVR (RCOPRD1).
      * ----------------------------------------------------------------
      * ----------------------------------------------------------------
      * Unmarshall CASHR-ORG-PROFL-READ-DRVR-I
      * ----------------------------------------------------------------
          UNMARSHALL-VCOPRDI1 SECTION.
           MOVE 1 TO MESSAGE-POS
           INITIALIZE CASHR-ORG-PROFL-READ-DRVR-I
      *    Unmarshall subrecord CASHR-ORG-PROFL-PK
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SWB-ORG-CD
                IN CASHR-ORG-PROFL-PK
                IN CASHR-ORG-PROFL-READ-DRVR-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
           .

      * ----------------------------------------------------------------
      * Marshall CASHR-ORG-PROFL-READ-DRVR-O
      * ----------------------------------------------------------------
          MARSHALL-VCOPRDO1 SECTION.
           MOVE 1 TO MESSAGE-POS
      *    Marshall subrecord STD-RTRN-DATA
      *    Marshall SMALLINT
           MOVE EXEC-STAT-CD
                IN STD-RTRN-DATA
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(7)
           MOVE MODUL-ID IN STD-RTRN-DATA IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:7)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 7
      *    Marshall SMALLINT
           MOVE MODUL-LOC-NR
                IN STD-RTRN-DATA
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall INTEGER
           MOVE RTRN-CD IN STD-RTRN-DATA IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall subrecord STD-FLD-INFO
      *    Marshall SMALLINT
           MOVE FLD-ID IN STD-FLD-INFO IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall SMALLINT
           MOVE FLD-STAT-CD
                IN STD-FLD-INFO
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall SMALLINT
           MOVE FLD-MSG-CD
                IN STD-FLD-INFO
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall SMALLINT
           MOVE FLD-OCCR IN STD-FLD-INFO IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall subrecord STD-FLD-MSG-COUNTS
      *    Marshall SMALLINT
           MOVE TOT-MSG-COUNT-NR
                IN STD-FLD-MSG-COUNTS
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall SMALLINT
           MOVE TOT-ERR-COUNT-NR
                IN STD-FLD-MSG-COUNTS
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall SMALLINT
           MOVE TOT-WARNG-COUNT-NR
                IN STD-FLD-MSG-COUNTS
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall SMALLINT
           MOVE TOT-INFO-COUNT-NR
                IN STD-FLD-MSG-COUNTS
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall subrecord CASHR-ORG-PROFL-ENT-GRP
      *    Marshall subrecord CASHR-ORG-PROFL
      *    Marshall CHAR(8)
           MOVE SWB-ORG-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall CHAR(60)
           MOVE SWB-ORG-NM
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:60)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 60
      *    Marshall CHAR(4)
           MOVE ORG-COMTRACK-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall CHAR(8)
           MOVE SWB-ORG-TYPE-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall CHAR(3)
           MOVE ORG-FAX-AREA-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(3)
           MOVE ORG-FAX-PRFX-NR
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(4)
           MOVE ORG-FAX-LINE-NR
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall CHAR(5)
           MOVE ORG-FAX-EXT-NR
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:5)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Marshall CHAR(3)
           MOVE ORG-PHON-AREA-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(3)
           MOVE ORG-PHON-PRFX-NR
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:3)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Marshall CHAR(4)
           MOVE ORG-PHON-LINE-NR
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:4)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Marshall CHAR(5)
           MOVE ORG-PHON-EXT-NR
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:5)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Marshall CHAR(8)
           MOVE PARNT-SWB-ORG-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall CHAR(8)
           MOVE HQ-SPEED-DIAL-CD
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall VARCHAR(8)
           MOVE PRINT-DSTN-ID-LEN
                IN PRINT-DSTN-ID-V
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           MOVE PRINT-DSTN-ID
                IN PRINT-DSTN-ID-V
                IN CASHR-ORG-PROFL
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:8)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Marshall SMALLINT
           MOVE AUDIT-INTG-CNTL-NR
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall subrecord AUDIT-DATA
      *    Marshall INTEGER
           MOVE AUDIT-UPDT-DT
                IN AUDIT-DATA
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall INTEGER
           MOVE AUDIT-UPDT-TM
                IN AUDIT-DATA
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall CHAR(17)
           MOVE AUDIT-USER-ID
                IN AUDIT-DATA
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:17)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 17
      *    Marshall CHAR(16)
           MOVE AUDIT-PWS-ID
                IN AUDIT-DATA
                IN CASHR-ORG-PROFL-ENT-GRP
                IN CASHR-ORG-PROFL-READ-DRVR-O
                TO MESSAGE-BODY(MESSAGE-POS:16)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16.



      * ----------------------------------------------------------------
      * Routines for marshalling and unmarshalling view(s) associated
      * with CASHR-USER-PROFL-UPDT (RCUPU01).
      * ----------------------------------------------------------------
      * ----------------------------------------------------------------
      * Unmarshall CASHR-USER-PROFL-UPDT-I
      * ----------------------------------------------------------------
          UNMARSHALL-VCUPUI01 SECTION.
           MOVE 1 TO MESSAGE-POS
           INITIALIZE CASHR-USER-PROFL-UPDT-I
      *    Unmarshall subrecord CASHR-USER-PROFL
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO CASHR-TRAN-RLOV-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SWB-ORG-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall VARCHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO PRINT-DSTN-ID-LEN
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO PRINT-DSTN-ID
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall INTEGER
           MOVE MESSAGE-BODY(MESSAGE-POS:11) TO IBM-INTEGER
           MOVE IBM-INTEGER-NUM
                TO CUT-OFF-TM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO IN-STATE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO REDEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO AR-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO CASHR-TRAN-FEE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall INTEGER
           MOVE MESSAGE-BODY(MESSAGE-POS:11) TO IBM-INTEGER
           MOVE IBM-INTEGER-NUM
                TO CASHR-TRAN-POST-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO CHECK-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall SMALLINT
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO DEP-CNTRB-YEAR-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO FUND-MED-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO LATE-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO EMP-USER-ID
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall CHAR(15)
           MOVE MESSAGE-BODY(MESSAGE-POS:15)
                TO TOA-CONTRA-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 15
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO FUND-RQST-CRNCY-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO KEO-NON-DED-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall DEC(15, 2)
           MOVE MESSAGE-BODY(MESSAGE-POS:16) TO IBM-DEC-15-2
           MOVE IBM-DEC-15-2-NUM
                TO CASHR-TRAN-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO TOA-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall DEC(15, 2)
           MOVE MESSAGE-BODY(MESSAGE-POS:16) TO IBM-DEC-15-2
           MOVE IBM-DEC-15-2-NUM
                TO FUND-RQST-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO FUND-RQST-SRCE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-FIRST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-MIDL-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-LAST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-NM-SUFF
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-NM-TITLE
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO USER-PHON-AREA-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO USER-PHON-PRFX-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO USER-PHON-LINE-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-PHON-EXT-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO USER-SEC-LEVEL-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall SMALLINT
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO AUDIT-INTG-CNTL-NR
                IN CASHR-USER-PROFL-UPDT-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           .

      * ----------------------------------------------------------------
      * Marshall CASHR-USER-PROFL-UPDT-O
      * ----------------------------------------------------------------
          MARSHALL-VCUPUO01 SECTION.
           MOVE 1 TO MESSAGE-POS
      *    Marshall subrecord STD-RTRN-DATA
      *    Marshall SMALLINT
           MOVE EXEC-STAT-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-UPDT-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(7)
           MOVE MODUL-ID IN STD-RTRN-DATA IN CASHR-USER-PROFL-UPDT-O
                TO MESSAGE-BODY(MESSAGE-POS:7)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 7
      *    Marshall SMALLINT
           MOVE MODUL-LOC-NR IN STD-RTRN-DATA IN CASHR-USER-PROFL-UPDT-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall INTEGER
           MOVE RTRN-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-UPDT-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall SMALLINT
           MOVE AUDIT-INTG-CNTL-NR IN CASHR-USER-PROFL-UPDT-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6.



      * ----------------------------------------------------------------
      * Routines for marshalling and unmarshalling view(s) associated
      * with CASHR-USER-PROFL-ADD (RCUPA01).
      * ----------------------------------------------------------------
      * ----------------------------------------------------------------
      * Unmarshall CASHR-USER-PROFL-ADD-I
      * ----------------------------------------------------------------
          UNMARSHALL-VCUPAI01 SECTION.
           MOVE 1 TO MESSAGE-POS
           INITIALIZE CASHR-USER-PROFL-ADD-I
      *    Unmarshall subrecord CASHR-USER-PROFL
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO CASHR-TRAN-RLOV-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO SWB-ORG-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall VARCHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO PRINT-DSTN-ID-LEN
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO PRINT-DSTN-ID
                IN PRINT-DSTN-ID-V
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall INTEGER
           MOVE MESSAGE-BODY(MESSAGE-POS:11) TO IBM-INTEGER
           MOVE IBM-INTEGER-NUM
                TO CUT-OFF-TM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO IN-STATE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO REDEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO AR-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO CASHR-TRAN-FEE-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall INTEGER
           MOVE MESSAGE-BODY(MESSAGE-POS:11) TO IBM-INTEGER
           MOVE IBM-INTEGER-NUM
                TO CASHR-TRAN-POST-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO CHECK-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall SMALLINT
           MOVE MESSAGE-BODY(MESSAGE-POS:6) TO IBM-SMALLINT
           MOVE IBM-SMALLINT-NUM
                TO DEP-CNTRB-YEAR-DT
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO FUND-MED-TYPE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO LATE-DEP-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall CHAR(8)
           MOVE MESSAGE-BODY(MESSAGE-POS:8)
                TO EMP-USER-ID
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 8
      *    Unmarshall CHAR(15)
           MOVE MESSAGE-BODY(MESSAGE-POS:15)
                TO TOA-CONTRA-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 15
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO FUND-RQST-CRNCY-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO KEO-NON-DED-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall DEC(15, 2)
           MOVE MESSAGE-BODY(MESSAGE-POS:16) TO IBM-DEC-15-2
           MOVE IBM-DEC-15-2-NUM
                TO CASHR-TRAN-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Unmarshall CHAR(1)
           MOVE MESSAGE-BODY(MESSAGE-POS:1)
                TO TOA-IN
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 1
      *    Unmarshall DEC(15, 2)
           MOVE MESSAGE-BODY(MESSAGE-POS:16) TO IBM-DEC-15-2
           MOVE IBM-DEC-15-2-NUM
                TO FUND-RQST-AM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 16
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO FUND-RQST-SRCE-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-FIRST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-MIDL-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(30)
           MOVE MESSAGE-BODY(MESSAGE-POS:30)
                TO USER-LAST-NM
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 30
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-NM-SUFF
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-NM-TITLE
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO USER-PHON-AREA-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(3)
           MOVE MESSAGE-BODY(MESSAGE-POS:3)
                TO USER-PHON-PRFX-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 3
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO USER-PHON-LINE-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
      *    Unmarshall CHAR(5)
           MOVE MESSAGE-BODY(MESSAGE-POS:5)
                TO USER-PHON-EXT-NR
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 5
      *    Unmarshall CHAR(4)
           MOVE MESSAGE-BODY(MESSAGE-POS:4)
                TO USER-SEC-LEVEL-CD
                IN CASHR-USER-PROFL
                IN CASHR-USER-PROFL-ADD-I
           COMPUTE MESSAGE-POS = MESSAGE-POS + 4
           .

      * ----------------------------------------------------------------
      * Marshall CASHR-USER-PROFL-ADD-O
      * ----------------------------------------------------------------
          MARSHALL-VCUPAO01 SECTION.
           MOVE 1 TO MESSAGE-POS
      *    Marshall subrecord STD-RTRN-DATA
      *    Marshall SMALLINT
           MOVE EXEC-STAT-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-ADD-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall CHAR(7)
           MOVE MODUL-ID IN STD-RTRN-DATA IN CASHR-USER-PROFL-ADD-O
                TO MESSAGE-BODY(MESSAGE-POS:7)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 7
      *    Marshall SMALLINT
           MOVE MODUL-LOC-NR IN STD-RTRN-DATA IN CASHR-USER-PROFL-ADD-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6
      *    Marshall INTEGER
           MOVE RTRN-CD IN STD-RTRN-DATA IN CASHR-USER-PROFL-ADD-O
                TO IBM-INTEGER-NUM
           MOVE IBM-INTEGER TO MESSAGE-BODY(MESSAGE-POS:11)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 11
      *    Marshall SMALLINT
           MOVE AUDIT-INTG-CNTL-NR IN CASHR-USER-PROFL-ADD-O
                TO IBM-SMALLINT-NUM
           MOVE IBM-SMALLINT TO MESSAGE-BODY(MESSAGE-POS:6)
           COMPUTE MESSAGE-POS = MESSAGE-POS + 6.