       IDENTIFICATION DIVISION.
       PROGRAM-ID. RDTS001.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RDTS001
      *      LONG  Name - DATE_TIME_SRVC
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * DATE_TIME_FRMT2                AC8QHD
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  DATE_TIME_SRVC:                                             
      * **
      * **     This rule uses the component, DATE_TIME_SRVC, to get the 
      * **
      * **     mainframe date & time.  This rule is provided because    
      * **
      * **     there is a need to be able to use this functionality     
      * **
      * **     from the PC rules & they can't attach directly to an MVS 
      * **
      * **     component.                                               
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RDTS001'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *DATE_TIME_FRMT2_O                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-FRMT2-O.
         COPY ZAC8UHD.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- CGSDT01I
      *****************************************************************
      *DATE_TIME_SRVC_I                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-SRVC-I.
         COPY CGSDT01I.
      * OUTPUT VIEW -- CGSDT01O
      *****************************************************************
      *DATE_TIME_SRVC_O                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-SRVC-O.
         COPY CGSDT01O.
      /
       PROCEDURE DIVISION
           USING DATE-TIME-SRVC-I DATE-TIME-SRVC-O.
       
       INIT-SECTION.
       
           INITIALIZE DATE-TIME-SRVC-O.
       
       A100-MAINLINE .
       
           MOVE 'RDTS001'
              TO MODUL-ID OF DATE-TIME-SRVC-O.
      *
      *-=R2C=- "AC8QHD" is short name for rule "DATE_TIME_FRMT2"
      *
           CALL 'AC8QHD' USING 
             DATE-TIME-FRMT2-O.
           
      *
      ******************************************************************
      * ** This moves the output view of the component to the output    
      * **
      * ** view of the rule.                                            
      * **
      * ***************************************************************
      *
           EVALUATE EXEC-STAT-CD OF DATE-TIME-FRMT2-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               MOVE CURR-DT OF DATE-TIME-FRMT2-O
                  TO CURR-DT OF DATE-TIME-SRVC-O
               MOVE CURR-TM OF DATE-TIME-FRMT2-O
                  TO CURR-TM OF DATE-TIME-SRVC-O
             WHEN OTHER
               MOVE STD-RTRN-DATA OF DATE-TIME-FRMT2-O
                  TO STD-RTRN-DATA OF DATE-TIME-SRVC-O
               MOVE FAILURE OF EXEC-STAT-CODES
                  TO RTRN-CD OF DATE-TIME-SRVC-O
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.