       IDENTIFICATION DIVISION.
       PROGRAM-ID. RDER001.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RDER001
      *      LONG  Name - DB2_ERR_ROTN
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * BATCH_ABEND_CALL               CBAC001
      * CICS_LOG_ENTRY                 CCAC001
      * EIBLK_READ                     CEIR001
      * SQLCA_TO_ERR_MSG               CSTEM01
      * WRITE_TO_SYSOUT                CWTS001
      * HPSMODE                        HPSMODE
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RDER001'.
      *****************************************************************
      *EXEC_ENVRN_CD                              AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-ENVRN-CD.
         COPY SEXENCD.
      *****************************************************************
      *MAM_ERR_CD                                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 MAM-ERR-CD.
         COPY SMEC001.
      *****************************************************************
      *BATCH_ABEND_CALL_I                         AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 BATCH-ABEND-CALL-I.
         COPY CBAC001I.
      *****************************************************************
      *BATCH_ABEND_CALL_O                         AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 BATCH-ABEND-CALL-O.
         COPY CBAC001O.
      *****************************************************************
      *CICS_LOG_ENTRY_I                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CICS-LOG-ENTRY-I.
         COPY CCLE001I.
      *****************************************************************
      *CICS_LOG_ENTRY_O                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CICS-LOG-ENTRY-O.
         COPY CCLE001O.
      *****************************************************************
      *EIBLK_READ_I                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EIBLK-READ-I.
         COPY CEIR001I.
      *****************************************************************
      *EIBLK_READ_O                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EIBLK-READ-O.
         COPY CEIR001O.
      *****************************************************************
      *SQLCA_TO_ERR_MSG_I                         AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SQLCA-TO-ERR-MSG-I.
         COPY CSTEM01I.
      *****************************************************************
      *SQLCA_TO_ERR_MSG_O                         AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SQLCA-TO-ERR-MSG-O.
         COPY CSTEM01O.
      *****************************************************************
      *WRITE_TO_SYSOUT_I                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 WRITE-TO-SYSOUT-I.
         COPY CWTS001I.
      *****************************************************************
      *WRITE_TO_SYSOUT_O                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 WRITE-TO-SYSOUT-O.
         COPY CWTS001O.
      *****************************************************************
      *HPSMODEO                                   AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 HPSMODEO.
         COPY HPSMODEO.
       01 HPS-LOCAL-VARS.
         05 L-NDX-TX                PIC S9(9) COMP.
         05 L-ERR-MSG-4-TX          PIC X(10).
         05 L-ERR-MSG-5-TX          PIC X(8).
         05 L-SQL-KEY-TX            PIC X(100).
         05 L-SQL-ERR-TOKEN         PIC X(70).
         05 L-ERR-MSG-V.
           10 L-ERR-MSG-1-TX        PIC X(37).
           10 L-ERR-MSG-2-TX        PIC X(11).
           10 L-PGM-ID              PIC X(8).
           10 L-ERR-MSG-3-TX        PIC X(14).
           10 L-SQLCODE             PIC S9(8).
         05 L-ABEND-MSG-V.
           10 L-ABEND-MSG-1-TX      PIC X(250).
           10 L-ABEND-MSG-2-TX      PIC X(250).
           10 L-ABEND-MSG-3-TX      PIC X(250).
       01 R2C-LOCAL-VARS.
         05 R2C-TEMPVAR-000         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-001         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-002         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-003         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-004         PIC X(20).
         05 R2C-TEMPVAR-005         PIC X(104).
         05 R2C-TEMPVAR-006         PIC X(80).
         05 R2C-TEMPVAR-007         PIC X(108).
         05 R2C-TEMPVAR-008         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-009         PIC S9(5) COMP-3.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- RDER001I
      *****************************************************************
      *DB2_ERR_ROTN_I                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-I.
         COPY RDER001I.
      * OUTPUT VIEW -- RDER001O
      *****************************************************************
      *DB2_ERR_ROTN_O                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-O.
         COPY RDER001O.
      /
       PROCEDURE DIVISION
           USING DB2-ERR-ROTN-I DB2-ERR-ROTN-O.
       
       INIT-SECTION.
       
           INITIALIZE BATCH-ABEND-CALL-I.
           INITIALIZE CICS-LOG-ENTRY-I.
           INITIALIZE EIBLK-READ-I.
           INITIALIZE SQLCA-TO-ERR-MSG-I.
           INITIALIZE WRITE-TO-SYSOUT-I.
           INITIALIZE HPS-LOCAL-VARS.
           INITIALIZE DB2-ERR-ROTN-O.
       
       A100-MAINLINE .
       
      *
      * Initialise abend message
      *
           MOVE '*** Bad Error Code On DB2 Access ***'
              TO L-ERR-MSG-1-TX.
           MOVE 'Rulename = '
              TO L-ERR-MSG-2-TX.
           MOVE ' Error Code = '
              TO L-ERR-MSG-3-TX.
           MOVE ' Tokens = '
              TO L-ERR-MSG-4-TX.
           MOVE ' Keys = '
              TO L-ERR-MSG-5-TX.
      *
      * Call component to determine execution environment
      *-=R2C=- HPSMODE component is not converted - CICS assumed.
      *
      *
      * SQLCA_VIEW and SQL KEY PARAMETERS
      *
           MOVE CORRESPONDING DB2-ERR-ROTN-I
              TO CICS-LOG-ENTRY-I.
               
           PERFORM 
             VARYING R2C-TEMPVAR-008
             FROM 1
             BY 1
             UNTIL (R2C-TEMPVAR-008 > 5)
                 
             MOVE SQL-STMT-PARM OF DB2-ERR-ROTN-I (R2C-TEMPVAR-008)
                TO SQL-STMT-PARM OF CICS-LOG-ENTRY-I (R2C-TEMPVAR-008)
           END-PERFORM.
               
           PERFORM 
             VARYING R2C-TEMPVAR-009
             FROM 1
             BY 1
             UNTIL (R2C-TEMPVAR-009 > 6)
                 
             MOVE SQLERRD OF SQLCA-VIEW OF DB2-ERR-ROTN-I (
               R2C-TEMPVAR-009)
                TO SQLERRD OF SQLCA-VIEW OF CICS-LOG-ENTRY-I (
                 R2C-TEMPVAR-009)
           END-PERFORM.
               
      *
      * OUO02005 is the CICS log code for a DB2 exception error
      *
           MOVE 'OUO02005'
              TO AUTO-OPER-MSG-ID OF CICS-LOG-ENTRY-I.
      *
      * Suppress the abend screen sent to the users CICS Session
      *
           MOVE 'N'
              TO SCRN-SLCT-IN OF CICS-LOG-ENTRY-I.
      *
      * Select option to build user abend message normally sent to
      *   the user cics session by FATAL ERROR. This message is what
      * will
      *   get passed back to the PC calling rule and displayed.
      *
           MOVE 'Y'
              TO AUTO-OPER-NOTC-IN OF CICS-LOG-ENTRY-I.
      *
      * Retrieve and pass DFHEIBLK fields
      *-=R2C=- "CEIR001" is short name for component "EIBLK_READ"
      *
           CALL 'CEIR001' USING 
                 EIBLK-READ-I 
                 EIBLK-READ-O.
               
           MOVE DFHEIBLK-CMMD-AREA OF EIBLK-READ-O
              TO DFHEIBLK-CMMD-AREA OF CICS-LOG-ENTRY-I
      *
      *-=R2C=- "CCAC001" is short name for component "CICS_LOG_ENTRY"
      *
           CALL 'CCAC001' USING 
                 CICS-LOG-ENTRY-I 
                 CICS-LOG-ENTRY-O.
               
           MOVE DB2-ERR OF MAM-ERR-CD
              TO RTRN-CD OF DB2-ERR-ROTN-O.
      *
      * -=R2C=- added this exit point
      *
           GOBACK.