       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCUPUS1.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCUPUS1
      *      LONG  Name - CASHR_USER_PROFL_UPDT_SQL
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * DB2_ERR_ROTN                   RDER001
      *
      * TABLE-ID
      * -----------------------
      * CASHR_USER_PROFL
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      *****************************************************************
      * **                                                              
      *  **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      *  **
      * **  All rights reserved                                         
      *  **
      * **                                                              
      *  **
      * **  CASHR_USER_PROFL_UPDT_SQL:                                  
      *  **
      * **                                                              
      *  **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCUPUS1'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *PUBL_ERR_CD                                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 PUBL-ERR-CD.
         COPY SPERRCD.
      *****************************************************************
      *SQL_SOFT_ERR                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SQL-SOFT-ERR.
         COPY SSSE001.
       01 SSSE001-LOOKUP            REDEFINES SQL-SOFT-ERR.
         05 ITEMS                   PIC S9(4) COMP
                                    OCCURS 7 TIMES.
      *****************************************************************
      *DB2_ERR_ROTN_I                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-I.
         COPY RDER001I.
      *****************************************************************
      *DB2_ERR_ROTN_O                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-O.
         COPY RDER001O.
       01 HPS-LOCAL-VARS.
      *
      *****************************************************************
      *L_CASHR_USER_PROFL_F                       AREAS(COBOL COPYBOOK)
      *****************************************************************
      *
         05 L-CASHR-USER-PROFL-F.
             EXEC SQL
               INCLUDE ZAAGPHD
             END-EXEC.
      *
      *****************************************************************
      *L_AUDIT_DATA                               AREAS(COBOL COPYBOOK)
      *****************************************************************
      *
         05 L-AUDIT-DATA.
             EXEC SQL
               INCLUDE ZAAF0HD
             END-EXEC.
       01 R2C-LOCAL-VARS.
         05 R2C-TEMPVAR-000         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-001         PIC S9(5) COMP-3.
      *****************************************************************
      *SQLCA                                        AREAS(COBOL DCLGEN)
      *****************************************************************
           EXEC SQL
             INCLUDE SQLCA
           END-EXEC.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCUPUSI1
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_SQL_I                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-SQL-I.
         COPY VCUPUSI1.
      * OUTPUT VIEW -- VCUPUSO1
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_SQL_O                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-SQL-O.
         COPY VCUPUSO1.
      /
       PROCEDURE DIVISION
           USING CASHR-USER-PROFL-UPDT-SQL-I CASHR-USER-PROFL-UPDT-SQL-O
             .
       
       INIT-SECTION.
       
           INITIALIZE DB2-ERR-ROTN-I.
           INITIALIZE SQLCA.
           INITIALIZE HPS-LOCAL-VARS.
           INITIALIZE CASHR-USER-PROFL-UPDT-SQL-O.
       
       A100-MAINLINE .
       
           MOVE 'RCUPUS1'
              TO MODUL-ID OF CASHR-USER-PROFL-UPDT-SQL-O.
           MOVE 'RCUPUS1'
              TO PGM-ID OF DB2-ERR-ROTN-I.
           MOVE CASHR-USER-PROFL-F OF CASHR-USER-PROFL-UPDT-SQL-I
              TO L-CASHR-USER-PROFL-F.
           MOVE AUDIT-DATA OF CASHR-USER-PROFL-UPDT-SQL-I
              TO L-AUDIT-DATA.
      *
      *****************************************************************
      * **                                                              
      *  **
      * **  UPDATE SQL:  Customize as appropriate to the table.         
      *  **
      * **                                                              
      *  **
      * ***************************************************************
      *
           EXEC SQL
             UPDATE CASHR_USER_PROFL SET 
               EMP_USER_ID = :L-CASHR-USER-PROFL-F.EMP-USER-ID, 
               CUT_OFF_TM = :L-CASHR-USER-PROFL-F.CUT-OFF-TM, 
               PRINT_DSTN_ID = :L-CASHR-USER-PROFL-F.PRINT-DSTN-ID-V, 
               SWB_ORG_CD = :L-CASHR-USER-PROFL-F.SWB-ORG-CD, 
               LATE_DEP_IN = :L-CASHR-USER-PROFL-F.LATE-DEP-IN, 
               CASHR_TRAN_AM = :L-CASHR-USER-PROFL-F.CASHR-TRAN-AM, 
               REDEP_IN = :L-CASHR-USER-PROFL-F.REDEP-IN, 
               FUND_MED_TYPE_CD = :L-CASHR-USER-PROFL-F.FUND-MED-TYPE-CD
                 , 
               DEP_CNTRB_YEAR_DT = 
                 :L-CASHR-USER-PROFL-F.DEP-CNTRB-YEAR-DT, 
               CASHR_TRAN_RLOV_IN = 
                 :L-CASHR-USER-PROFL-F.CASHR-TRAN-RLOV-IN, 
               CASHR_TRAN_FEE_IN = 
                 :L-CASHR-USER-PROFL-F.CASHR-TRAN-FEE-IN, 
               CHECK_TYPE_CD = :L-CASHR-USER-PROFL-F.CHECK-TYPE-CD, 
               IN_STATE_IN = :L-CASHR-USER-PROFL-F.IN-STATE-IN, 
               CASHR_TRAN_POST_DT = 
                 :L-CASHR-USER-PROFL-F.CASHR-TRAN-POST-DT, 
               AR_DEP_IN = :L-CASHR-USER-PROFL-F.AR-DEP-IN, 
               FUND_RQST_AM = :L-CASHR-USER-PROFL-F.FUND-RQST-AM, 
               TOA_IN = :L-CASHR-USER-PROFL-F.TOA-IN, 
               KEO_NON_DED_IN = :L-CASHR-USER-PROFL-F.KEO-NON-DED-IN, 
               FUND_RQST_CRNCY_CD = 
                 :L-CASHR-USER-PROFL-F.FUND-RQST-CRNCY-CD, 
               TOA_CONTRA_NM = :L-CASHR-USER-PROFL-F.TOA-CONTRA-NM, 
               USER_FIRST_NM = :L-CASHR-USER-PROFL-F.USER-FIRST-NM, 
               USER_MIDL_NM = :L-CASHR-USER-PROFL-F.USER-MIDL-NM, 
               USER_LAST_NM = :L-CASHR-USER-PROFL-F.USER-LAST-NM, 
               USER_NM_SUFF = :L-CASHR-USER-PROFL-F.USER-NM-SUFF, 
               USER_NM_TITLE = :L-CASHR-USER-PROFL-F.USER-NM-TITLE, 
               USER_PHON_AREA_CD = 
                 :L-CASHR-USER-PROFL-F.USER-PHON-AREA-CD, 
               USER_PHON_PRFX_NR = 
                 :L-CASHR-USER-PROFL-F.USER-PHON-PRFX-NR, 
               USER_PHON_LINE_NR = 
                 :L-CASHR-USER-PROFL-F.USER-PHON-LINE-NR, 
               USER_PHON_EXT_NR = :L-CASHR-USER-PROFL-F.USER-PHON-EXT-NR
                 , 
               USER_SEC_LEVEL_CD = 
                 :L-CASHR-USER-PROFL-F.USER-SEC-LEVEL-CD, 
               AUDIT_USER_ID = :L-AUDIT-DATA.AUDIT-USER-ID, 
               AUDIT_PWS_ID = :L-AUDIT-DATA.AUDIT-PWS-ID, 
               AUDIT_UPDT_DT = :L-AUDIT-DATA.AUDIT-UPDT-DT, 
               AUDIT_UPDT_TM = :L-AUDIT-DATA.AUDIT-UPDT-TM, 
               AUDIT_INTG_CNTL_NR = AUDIT_INTG_CNTL_NR + 1
               WHERE EMP_USER_ID = :L-CASHR-USER-PROFL-F.EMP-USER-ID AND
                AUDIT_INTG_CNTL_NR = 
                 :L-CASHR-USER-PROFL-F.AUDIT-INTG-CNTL-NR
           END-EXEC.
           
      *
      *****************************************************************
      * **                                                              
      *  **
      * **  SQL RETURN CODE CHECKING: Customize as required by the      
      *  **
      * **                            application.                      
      *  **
      * **                                                              
      *  **
      * ***************************************************************
      *
           MOVE SQLCODE OF SQLCA
              TO RTRN-CD OF CASHR-USER-PROFL-UPDT-SQL-O.
           
           EVALUATE SQLCODE OF SQLCA
             WHEN SUCCESS OF EXEC-STAT-CODES
               CONTINUE
             WHEN ROW-NOT-FOUND OF SQL-SOFT-ERR
               MOVE CNTL-NR-NOT-EQ OF PUBL-ERR-CD
                  TO RTRN-CD OF CASHR-USER-PROFL-UPDT-SQL-O
             WHEN OTHER
      *
      *-=R2C=- inset %sSQL-SOFT-ERR
      *
               PERFORM 
                 VARYING R2C-TEMPVAR-000
                 FROM 1
                 BY 1
                 UNTIL (R2C-TEMPVAR-000 > 7 OR SQLCODE OF SQLCA = ITEMS
                    OF SSSE001-LOOKUP (R2C-TEMPVAR-000))
                 
               END-PERFORM
               
               IF (R2C-TEMPVAR-000 <= 7) THEN
                 CONTINUE
               ELSE
                 MOVE '(user value)'
                    TO SQL-PARM-TX OF DB2-ERR-ROTN-I (1)
                 MOVE '(user value)'
                    TO SQL-PARM-TX OF DB2-ERR-ROTN-I (2)
                 MOVE CORRESPONDING SQLCA
                    TO SQLCA-VIEW OF DB2-ERR-ROTN-I
                 
                 PERFORM 
                   VARYING R2C-TEMPVAR-001
                   FROM 1
                   BY 1
                   UNTIL (R2C-TEMPVAR-001 > 6)
                   
                   MOVE SQLERRD OF SQLCA (R2C-TEMPVAR-001)
                      TO SQLERRD OF SQLCA-VIEW OF DB2-ERR-ROTN-I (
                       R2C-TEMPVAR-001)
                 END-PERFORM
                 
      *
      *-=R2C=- "RDER001" is short name for rule "DB2_ERR_ROTN"
      *
                 CALL 'RDER001' USING 
                   DB2-ERR-ROTN-I 
                   DB2-ERR-ROTN-O
                 
                 MOVE FAILURE OF EXEC-STAT-CODES
                    TO EXEC-STAT-CD OF CASHR-USER-PROFL-UPDT-SQL-O
               END-IF
               
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.