       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCUPU01.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCUPU01
      *      LONG  Name - CASHR_USER_PROFL_UPDT
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * AUDIT_DATA_FRMT                RADF001
      * CASHR_USER_PROFL_UPDT_SQL      RCUPUS1
      * CASHR_USER_PROFL_UPDT_VRFY     RCUPUV1
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **  CASHR_USER_PROFL_UPDT:                                      
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCUPU01'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *AUDIT_DATA_FRMT_I                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 AUDIT-DATA-FRMT-I.
         COPY RADFI001.
      *****************************************************************
      *AUDIT_DATA_FRMT_O                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 AUDIT-DATA-FRMT-O.
         COPY RADFO001.
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_SQL_I                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-SQL-I.
         COPY VCUPUSI1.
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_SQL_O                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-SQL-O.
         COPY VCUPUSO1.
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_VRFY_I               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-VRFY-I.
         COPY VCUPUVI1.
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_VRFY_O               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-VRFY-O.
         COPY VCUPUVO1.
       01 R2C-LOCAL-VARS.
         05 R2C-TEMPVAR-000         PIC S9(7) COMP-3.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCUPUI01
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_I                    AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-I.
         COPY VCUPUI01.
      * OUTPUT VIEW -- VCUPUO01
      *****************************************************************
      *CASHR_USER_PROFL_UPDT_O                    AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-UPDT-O.
         COPY VCUPUO01.
      /
       PROCEDURE DIVISION
           USING CASHR-USER-PROFL-UPDT-I CASHR-USER-PROFL-UPDT-O.
       
       INIT-SECTION.
       
           INITIALIZE AUDIT-DATA-FRMT-I.
           INITIALIZE CASHR-USER-PROFL-UPDT-SQL-I.
           INITIALIZE CASHR-USER-PROFL-UPDT-VRFY-I.
           INITIALIZE CASHR-USER-PROFL-UPDT-O.
       
       A100-MAINLINE .
       
           MOVE 'RCUPU01'
              TO MODUL-ID OF CASHR-USER-PROFL-UPDT-O.
      *
      ******************************************************************
      * **                                                              
      * **
      * **  ENTITY VERIFICATION:                                        
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           MOVE CORRESPONDING CASHR-USER-PROFL-UPDT-I
              TO CASHR-USER-PROFL-UPDT-VRFY-I.
      *
      *-=R2C=- "RCUPUV1" is short name for rule
      * "CASHR_USER_PROFL_UPDT_VRFY"
      *
           CALL 'RCUPUV1' USING 
             CASHR-USER-PROFL-UPDT-VRFY-I 
             CASHR-USER-PROFL-UPDT-VRFY-O.
           
           EVALUATE RTRN-CD OF CASHR-USER-PROFL-UPDT-VRFY-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               CONTINUE
             WHEN OTHER
               MOVE STD-RTRN-DATA OF CASHR-USER-PROFL-UPDT-VRFY-O
                  TO STD-RTRN-DATA OF CASHR-USER-PROFL-UPDT-O
               GOBACK
           END-EVALUATE.
           
      *
      ******************************************************************
      * **                                                              
      * **
      * **   FORMAT AUDIT DATA:                                         
      * **
      * **                                                              
      * **
      * ***************************************************************
      *-=R2C=- "RADF001" is short name for rule "AUDIT_DATA_FRMT"
      *
           CALL 'RADF001' USING 
             AUDIT-DATA-FRMT-I 
             AUDIT-DATA-FRMT-O.
           
           EVALUATE RTRN-CD OF AUDIT-DATA-FRMT-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               MOVE AUDIT-DATA OF AUDIT-DATA-FRMT-O
                  TO AUDIT-DATA OF CASHR-USER-PROFL-F OF 
                   CASHR-USER-PROFL-UPDT-SQL-I
             WHEN OTHER
               MOVE RTRN-CD OF AUDIT-DATA-FRMT-O
                  TO RTRN-CD OF CASHR-USER-PROFL-UPDT-O
               MOVE FAILURE OF EXEC-STAT-CODES
                  TO EXEC-STAT-CD OF CASHR-USER-PROFL-UPDT-O
               GOBACK
           END-EVALUATE.
           
      *
      ******************************************************************
      * **                                                              
      * **
      * **   FORMAT TABLE FILE VIEW and UPDATE DB2:                     
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           MOVE CORRESPONDING CASHR-USER-PROFL OF 
             CASHR-USER-PROFL-UPDT-I
              TO CASHR-USER-PROFL-F OF CASHR-USER-PROFL-UPDT-SQL-I.
           MOVE AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-UPDT-I
              TO AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-UPDT-SQL-I.
      *
      *-=R2C=- "RCUPUS1" is short name for rule
      * "CASHR_USER_PROFL_UPDT_SQL"
      *
           CALL 'RCUPUS1' USING 
             CASHR-USER-PROFL-UPDT-SQL-I 
             CASHR-USER-PROFL-UPDT-SQL-O.
           
           EVALUATE RTRN-CD OF CASHR-USER-PROFL-UPDT-SQL-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               COMPUTE R2C-TEMPVAR-000 = (AUDIT-INTG-CNTL-NR OF 
                 CASHR-USER-PROFL-UPDT-I + 1)
               MOVE R2C-TEMPVAR-000
                  TO AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-UPDT-O
             WHEN OTHER
               MOVE STD-RTRN-DATA OF CASHR-USER-PROFL-UPDT-SQL-O
                  TO STD-RTRN-DATA OF CASHR-USER-PROFL-UPDT-O
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.