       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCUPR01.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCUPR01
      *      LONG  Name - CASHR_USER_PROFL_READ
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * CASHR_USER_PROFL_READ_SQL      RCUPRS1
      * DATE_TIME_SRVC                 RDTS001
      * EMP_SIGN_ON_ID_READ_CICS       CESOIRC
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  CASHR_USER_PROFL_READ:  Full entity read of default values  
      * **
      * **  for a Cashiering User.  Includes current date.  If User_ID  
      * **
      * **  is not input, will default to who ever is signed on.  If    
      * **
      * **  no Profile is found, returns the User_ID.                   
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCUPR01'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *CASHR_USER_PROFL_READ_SQL_I                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-READ-SQL-I.
         COPY VCUPRSI1.
      *****************************************************************
      *CASHR_USER_PROFL_READ_SQL_O                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-READ-SQL-O.
         COPY VCUPRSO1.
      *****************************************************************
      *DATE_TIME_SRVC_I                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-SRVC-I.
         COPY CGSDT01I.
      *****************************************************************
      *DATE_TIME_SRVC_O                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-SRVC-O.
         COPY CGSDT01O.
      *****************************************************************
      *EMP_SIGN_ON_ID_READ_CICS_I                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EMP-SIGN-ON-ID-READ-CICS-I.
         COPY CESOIRCI.
      *****************************************************************
      *EMP_SIGN_ON_ID_READ_CICS_O                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EMP-SIGN-ON-ID-READ-CICS-O.
         COPY CESOIRCO.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCUPRI01
      *****************************************************************
      *CASHR_USER_PROFL_READ_I                    AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-READ-I.
         COPY VCUPRI01.
      * OUTPUT VIEW -- VCUPRO01
      *****************************************************************
      *CASHR_USER_PROFL_READ_O                    AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-READ-O.
         COPY VCUPRO01.
      /
       PROCEDURE DIVISION
           USING CASHR-USER-PROFL-READ-I CASHR-USER-PROFL-READ-O.
       
       INIT-SECTION.
       
           INITIALIZE CASHR-USER-PROFL-READ-SQL-I.
           INITIALIZE DATE-TIME-SRVC-I.
           INITIALIZE EMP-SIGN-ON-ID-READ-CICS-I.
           INITIALIZE CASHR-USER-PROFL-READ-O.
       
       A100-MAINLINE .
       
           MOVE 'RCUPR01'
              TO MODUL-ID OF CASHR-USER-PROFL-READ-O.
      *
      ******************************************************************
      * **                                                              
      * **
      * **   Read today's Date so all Clients use the same date.        
      * **
      * **                                                              
      * **
      * ***************************************************************
      *-=R2C=- "RDTS001" is short name for rule "DATE_TIME_SRVC"
      *
           CALL 'RDTS001' USING 
             DATE-TIME-SRVC-I 
             DATE-TIME-SRVC-O.
           
           EVALUATE RTRN-CD OF DATE-TIME-SRVC-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               MOVE CURR-DT OF DATE-TIME-SRVC-O
                  TO CURR-DT OF CASHR-USER-PROFL-READ-O
             WHEN OTHER
               MOVE RTRN-CD OF DATE-TIME-SRVC-O
                  TO RTRN-CD OF STD-RTRN-DATA OF CASHR-USER-PROFL-READ-O
               MOVE FAILURE OF EXEC-STAT-CODES
                  TO EXEC-STAT-CD OF STD-RTRN-DATA OF 
                   CASHR-USER-PROFL-READ-O
           END-EVALUATE.
           
      *
      ******************************************************************
      * **                                                              
      * **
      * **   FORMAT TABLE KEY and READ DB2:  User can input an ID or    
      * **
      * **   default to their own.                                      
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           IF (EMP-USER-ID OF CASHR-USER-PROFL-PK OF 
             CASHR-USER-PROFL-READ-I = '        ') THEN
      *
      *-=R2C=- "CESOIRC" is short name for component
      * "EMP_SIGN_ON_ID_READ_CICS"
      *
             CALL 'CESOIRC' USING 
               EMP-SIGN-ON-ID-READ-CICS-I 
               EMP-SIGN-ON-ID-READ-CICS-O
             
             EVALUATE RTRN-CD OF EMP-SIGN-ON-ID-READ-CICS-O
               WHEN SUCCESS OF EXEC-STAT-CODES
                 MOVE EMP-SIGN-ON-ID OF EMP-SIGN-ON-ID-READ-CICS-O
                    TO EMP-USER-ID OF CASHR-USER-PROFL-PK OF 
                     CASHR-USER-PROFL-READ-SQL-I
               WHEN OTHER
                 MOVE RTRN-CD OF EMP-SIGN-ON-ID-READ-CICS-O
                    TO RTRN-CD OF STD-RTRN-DATA OF 
                     CASHR-USER-PROFL-READ-O
                 MOVE FAILURE OF EXEC-STAT-CODES
                    TO EXEC-STAT-CD OF STD-RTRN-DATA OF 
                     CASHR-USER-PROFL-READ-O
             END-EVALUATE
             
           ELSE
             MOVE CASHR-USER-PROFL-PK OF CASHR-USER-PROFL-READ-I
                TO CASHR-USER-PROFL-PK OF CASHR-USER-PROFL-READ-SQL-I
           END-IF.
           
      *
      *-=R2C=- "RCUPRS1" is short name for rule
      * "CASHR_USER_PROFL_READ_SQL"
      *
           CALL 'RCUPRS1' USING 
             CASHR-USER-PROFL-READ-SQL-I 
             CASHR-USER-PROFL-READ-SQL-O.
           
           EVALUATE RTRN-CD OF CASHR-USER-PROFL-READ-SQL-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               MOVE CORRESPONDING CASHR-USER-PROFL-F OF 
                 CASHR-USER-PROFL-READ-SQL-O
                  TO CASHR-USER-PROFL OF CASHR-USER-PROFL-READ-O
               MOVE AUDIT-DATA OF CASHR-USER-PROFL-F OF 
                 CASHR-USER-PROFL-READ-SQL-O
                  TO AUDIT-DATA OF CASHR-USER-PROFL-READ-O
               MOVE AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-F OF 
                 CASHR-USER-PROFL-READ-SQL-O
                  TO AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-READ-O
             WHEN OTHER
               MOVE STD-RTRN-DATA OF CASHR-USER-PROFL-READ-SQL-O
                  TO STD-RTRN-DATA OF CASHR-USER-PROFL-READ-O
      *
      * Pass back User ID if not successful.
      *
               MOVE CORRESPONDING CASHR-USER-PROFL-PK OF 
                 CASHR-USER-PROFL-READ-SQL-I
                  TO CASHR-USER-PROFL OF CASHR-USER-PROFL-READ-O
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.