       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCUPDS2.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCUPDS2
      *      LONG  Name - CASHR_USER_PROFL_DEL_SQL
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * DB2_ERR_ROTN                   RDER001
      *
      * TABLE-ID
      * -----------------------
      * CASHR_USER_PROFL
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      *****************************************************************
      * **                                                              
      *  **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      *  **
      * **  All rights reserved                                         
      *  **
      * **                                                              
      *  **
      * **                                                              
      *  **
      * **  CASHR_USER_PROFL_DEL_SQL:                                   
      *  **
      * **                                                              
      *  **
      * **                     This rule applies deletes to a DB2 table.
      *  **
      * **                                                              
      *  **
      * **                     The programmer must provide all SQL code.
      *  **
      * **                     Standard error checks are provided, but  
      *  **
      * **                     the programmer may customize this
      * further, **
      * **                     deleting conditions which do not apply   
      *  **
      * **                     and adding others as required.           
      *  **
      * **                                                              
      *  **
      * **                                                              
      *  **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCUPDS2'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *SQL_SOFT_ERR                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SQL-SOFT-ERR.
         COPY SSSE001.
       01 SSSE001-LOOKUP            REDEFINES SQL-SOFT-ERR.
         05 ITEMS                   PIC S9(4) COMP
                                    OCCURS 7 TIMES.
      *****************************************************************
      *DB2_ERR_ROTN_I                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-I.
         COPY RDER001I.
      *****************************************************************
      *DB2_ERR_ROTN_O                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-O.
         COPY RDER001O.
       01 HPS-LOCAL-VARS.
      *
      *****************************************************************
      *L_CASHR_USER_PROFL_F                       AREAS(COBOL COPYBOOK)
      *****************************************************************
      *
         05 L-CASHR-USER-PROFL-F.
             EXEC SQL
               INCLUDE ZAAGPHD
             END-EXEC.
         05 L-AUDIT-INTG-CNTL-NR    PIC S9(4) COMP.
       01 R2C-LOCAL-VARS.
         05 R2C-TEMPVAR-000         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-001         PIC S9(5) COMP-3.
      *****************************************************************
      *SQLCA                                        AREAS(COBOL DCLGEN)
      *****************************************************************
           EXEC SQL
             INCLUDE SQLCA
           END-EXEC.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCUPDSI1
      *****************************************************************
      *CASHR_USER_PROFL_DEL_SQL_I                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-DEL-SQL-I.
         COPY VCUPDSI1.
      * OUTPUT VIEW -- VCUPDSO1
      *****************************************************************
      *CASHR_USER_PROFL_DEL_SQL_O                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-DEL-SQL-O.
         COPY VCUPDSO1.
      /
       PROCEDURE DIVISION
           USING CASHR-USER-PROFL-DEL-SQL-I CASHR-USER-PROFL-DEL-SQL-O.
       
       INIT-SECTION.
       
           INITIALIZE DB2-ERR-ROTN-I.
           INITIALIZE SQLCA.
           INITIALIZE HPS-LOCAL-VARS.
           INITIALIZE CASHR-USER-PROFL-DEL-SQL-O.
       
       A100-MAINLINE .
       
           MOVE 'RCUPDS2'
              TO MODUL-ID OF CASHR-USER-PROFL-DEL-SQL-O.
           MOVE 'RCUPDS2'
              TO PGM-ID OF DB2-ERR-ROTN-I.
           MOVE CASHR-USER-PROFL-F OF CASHR-USER-PROFL-DEL-SQL-I
              TO L-CASHR-USER-PROFL-F.
           MOVE AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-F OF 
             CASHR-USER-PROFL-DEL-SQL-I
              TO L-AUDIT-INTG-CNTL-NR.
      *
      *****************************************************************
      * **                                                              
      *  **
      * **  DELETE SQL:  Customize as appropriate to the table.         
      *  **
      * **                                                              
      *  **
      * ***************************************************************
      *
           EXEC SQL
             DELETE FROM CASHR_USER_PROFL
               WHERE (EMP_USER_ID = :L-CASHR-USER-PROFL-F.EMP-USER-ID
                  AND
                AUDIT_INTG_CNTL_NR = :L-AUDIT-INTG-CNTL-NR)
           END-EXEC.
           
      *
      *****************************************************************
      * **                                                              
      *  **
      * **  SQL RETURN CODE CHECKING: Customize as required by the      
      *  **
      * **                            application.                      
      *  **
      * **                                                              
      *  **
      * ***************************************************************
      *
           MOVE SQLCODE OF SQLCA
              TO RTRN-CD OF CASHR-USER-PROFL-DEL-SQL-O.
           
           EVALUATE SQLCODE OF SQLCA
             WHEN SUCCESS OF EXEC-STAT-CODES
               CONTINUE
             WHEN OTHER
      *
      *-=R2C=- inset %sSQL-SOFT-ERR
      *
               PERFORM 
                 VARYING R2C-TEMPVAR-000
                 FROM 1
                 BY 1
                 UNTIL (R2C-TEMPVAR-000 > 7 OR SQLCODE OF SQLCA = ITEMS
                    OF SSSE001-LOOKUP (R2C-TEMPVAR-000))
                 
               END-PERFORM
               
               IF (R2C-TEMPVAR-000 <= 7) THEN
                 CONTINUE
               ELSE
                 MOVE 'Employee ID '
                    TO SQL-PARM-TX OF DB2-ERR-ROTN-I (1)
                 MOVE EMP-USER-ID OF CASHR-USER-PROFL-F
                    TO SQL-PARM-TX OF DB2-ERR-ROTN-I (2)
                 MOVE CORRESPONDING SQLCA
                    TO SQLCA-VIEW OF DB2-ERR-ROTN-I
                 
                 PERFORM 
                   VARYING R2C-TEMPVAR-001
                   FROM 1
                   BY 1
                   UNTIL (R2C-TEMPVAR-001 > 6)
                   
                   MOVE SQLERRD OF SQLCA (R2C-TEMPVAR-001)
                      TO SQLERRD OF SQLCA-VIEW OF DB2-ERR-ROTN-I (
                       R2C-TEMPVAR-001)
                 END-PERFORM
                 
      *
      *-=R2C=- "RDER001" is short name for rule "DB2_ERR_ROTN"
      *
                 CALL 'RDER001' USING 
                   DB2-ERR-ROTN-I 
                   DB2-ERR-ROTN-O
                 
                 MOVE FAILURE OF EXEC-STAT-CODES
                    TO EXEC-STAT-CD OF CASHR-USER-PROFL-DEL-SQL-O
               END-IF
               
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.