       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCUPD01.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCUPD01
      *      LONG  Name - CASHR_USER_PROFL_DEL
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * CASHR_USER_PROFL_DEL_SQL       RCUPDS2
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  CASHR_USER_PROFL_DEL:                                       
      * **
      * **                  This rule is used to perform entity deletes 
      * **
      * **                  to all the DB2 tables which make up that    
      * **
      * **                  entity.                                     
      * **
      * **                                                              
      * **
      * **                  Entity level verification is provided for   
      * **
      * **                  by invoking CASHR_USER_PROFL_DEL_VRFY. If
      * you are **
      * **                  not doing entity level verification, this   
      * **
      * **                  may be deleted.  See code below for further 
      * **
      * **                  instructions.                               
      * **
      * **                                                              
      * **
      * **                  Code is provided for a single table delete. 
      * **
      * **                  If the entity is made up of more than one   
      * **
      * **                  table, you will need to repeat the logic    
      * **
      * **                  for loading the table file view and delete  
      * **
      * **                  sql for each additional table.  The code to 
      * **
      * **                  do this is marked in the body of the rule.  
      * **
      * **                                                              
      * **
      * **                  This rule is a non-bridge rule.  If the     
      * **
      * **                  entity to be deleted also needs to be       
      * **
      * **                  bridged, do no use this rule.  To bridge    
      * **
      * **                  entity deletes use rule
      * CASHR_USER_PROFL_BUPDT. **
      * **                                                              
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCUPD01'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *CASHR_USER_PROFL_DEL_SQL_I                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-DEL-SQL-I.
         COPY VCUPDSI1.
      *****************************************************************
      *CASHR_USER_PROFL_DEL_SQL_O                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-DEL-SQL-O.
         COPY VCUPDSO1.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCUPDI01
      *****************************************************************
      *CASHR_USER_PROFL_DEL_I                     AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-DEL-I.
         COPY VCUPDI01.
      * OUTPUT VIEW -- VCUPDO02
      *****************************************************************
      *CASHR_USER_PROFL_DEL_O                     AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-USER-PROFL-DEL-O.
         COPY VCUPDO02.
      /
       PROCEDURE DIVISION
           USING CASHR-USER-PROFL-DEL-I CASHR-USER-PROFL-DEL-O.
       
       INIT-SECTION.
       
           INITIALIZE CASHR-USER-PROFL-DEL-SQL-I.
           INITIALIZE CASHR-USER-PROFL-DEL-O.
       
       A100-MAINLINE .
       
           MOVE 'RCUPD01'
              TO MODUL-ID OF CASHR-USER-PROFL-DEL-O.
      *
      ******************************************************************
      * **                                                              
      * **
      * **   FORMAT TABLE FILE VIEW and DELETE DB2:                     
      * **
      * **                                                              
      * **
      * **   Map the key fields from the entity view to the key view    
      * **
      * **   of the delete SQL rule.  Map the audit information from    
      * **
      * **   the entity view to the audit info of the delete SQL rule.  
      * **
      * **   Invoke the delete.                                         
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           MOVE CORRESPONDING CASHR-USER-PROFL OF CASHR-USER-PROFL-DEL-I
              TO CASHR-USER-PROFL-F OF CASHR-USER-PROFL-DEL-SQL-I.
           MOVE AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-DEL-I
              TO AUDIT-INTG-CNTL-NR OF CASHR-USER-PROFL-F OF 
               CASHR-USER-PROFL-DEL-SQL-I.
      *
      *-=R2C=- "RCUPDS2" is short name for rule
      * "CASHR_USER_PROFL_DEL_SQL"
      *
           CALL 'RCUPDS2' USING 
             CASHR-USER-PROFL-DEL-SQL-I 
             CASHR-USER-PROFL-DEL-SQL-O.
           
           EVALUATE RTRN-CD OF CASHR-USER-PROFL-DEL-SQL-O
             WHEN SUCCESS OF EXEC-STAT-CODES
               CONTINUE
             WHEN OTHER
               MOVE STD-RTRN-DATA OF CASHR-USER-PROFL-DEL-SQL-O
                  TO STD-RTRN-DATA OF CASHR-USER-PROFL-DEL-O
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.