       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCOPRS1.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCOPRS1
      *      LONG  Name - CASHR_ORG_PROFL_READ_SQL
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * DB2_ERR_ROTN                   RDER001
      *
      * TABLE-ID
      * -----------------------
      * CASHR_ORG_PROFL
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  CASHR_ORG_PROFL_READ_SQL:                                   
      * **
      * **                                                              
      * **
      * **                    This rule reads a single row from a       
      * **
      * **                    DB2 table.                                
      * **
      * **                                                              
      * **
      * **                    The programmer must supply all SQL code.  
      * **
      * **                    Standard error checks are provided, but   
      * **
      * **                    the programmer may customize this further,
      * **
      * **                    deleting conditions which do no apply and 
      * **
      * **                    adding others as required.                
      * **
      * **                                                              
      * **
      * **                    Note that the programmer must also supply 
      * **
      * **                    user messages for the DB2 error routine.  
      * **
      * **                    See '(user message)' item below.          
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCOPRS1'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *SQL_SOFT_ERR                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SQL-SOFT-ERR.
         COPY SSSE001.
       01 SSSE001-LOOKUP            REDEFINES SQL-SOFT-ERR.
         05 ITEMS                   PIC S9(4) COMP
                                    OCCURS 7 TIMES.
      *****************************************************************
      *DB2_ERR_ROTN_I                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-I.
         COPY RDER001I.
      *****************************************************************
      *DB2_ERR_ROTN_O                             AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DB2-ERR-ROTN-O.
         COPY RDER001O.
       01 HPS-LOCAL-VARS.
      *
      *****************************************************************
      *L_CASHR_ORG_PROFL_PK                       AREAS(COBOL COPYBOOK)
      *****************************************************************
      *
         05 L-CASHR-ORG-PROFL-PK.
             EXEC SQL
               INCLUDE ZACS9HD
             END-EXEC.
      *
      *****************************************************************
      *L_CASHR_ORG_PROFL_F                        AREAS(COBOL COPYBOOK)
      *****************************************************************
      *
         05 L-CASHR-ORG-PROFL-F.
             EXEC SQL
               INCLUDE ZACS5HD
             END-EXEC.
      *
      *****************************************************************
      *L_AUDIT_DATA                               AREAS(COBOL COPYBOOK)
      *****************************************************************
      *
         05 L-AUDIT-DATA.
             EXEC SQL
               INCLUDE ZAAF0HD
             END-EXEC.
       01 R2C-LOCAL-VARS.
         05 R2C-TEMPVAR-000         PIC S9(5) COMP-3.
         05 R2C-TEMPVAR-001         PIC S9(5) COMP-3.
      *****************************************************************
      *SQLCA                                        AREAS(COBOL DCLGEN)
      *****************************************************************
           EXEC SQL
             INCLUDE SQLCA
           END-EXEC.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCOPRSI1
      *****************************************************************
      *CASHR_ORG_PROFL_READ_SQL_I                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-ORG-PROFL-READ-SQL-I.
         COPY VCOPRSI1.
      * OUTPUT VIEW -- VCOPRSO1
      *****************************************************************
      *CASHR_ORG_PROFL_READ_SQL_O                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-ORG-PROFL-READ-SQL-O.
         COPY VCOPRSO1.
      /
       PROCEDURE DIVISION
           USING CASHR-ORG-PROFL-READ-SQL-I CASHR-ORG-PROFL-READ-SQL-O.
       
       INIT-SECTION.
       
           INITIALIZE DB2-ERR-ROTN-I.
           INITIALIZE SQLCA.
           INITIALIZE HPS-LOCAL-VARS.
           INITIALIZE CASHR-ORG-PROFL-READ-SQL-O.
       
       A100-MAINLINE .
       
           MOVE 'RCOPRS1'
              TO PGM-ID OF DB2-ERR-ROTN-I.
           MOVE 'RCOPRS1'
              TO MODUL-ID OF CASHR-ORG-PROFL-READ-SQL-O.
           MOVE CASHR-ORG-PROFL-PK OF CASHR-ORG-PROFL-READ-SQL-I
              TO L-CASHR-ORG-PROFL-PK.
           MOVE FUNCTION UPPER-CASE (SWB-ORG-CD OF L-CASHR-ORG-PROFL-PK)
              TO SWB-ORG-CD OF L-CASHR-ORG-PROFL-PK.
      *
      ******************************************************************
      * **                                                              
      * **
      * **  READ SQL: Customize as appropriate to the table             
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           EXEC SQL
             SELECT 
               SWB_ORG_CD, 
               SWB_ORG_NM, 
               ORG_COMTRACK_CD, 
               SWB_ORG_TYPE_CD, 
               ORG_FAX_AREA_CD, 
               ORG_FAX_PRFX_NR, 
               ORG_FAX_LINE_NR, 
               ORG_FAX_EXT_NR, 
               ORG_PHON_AREA_CD, 
               ORG_PHON_PRFX_NR, 
               ORG_PHON_LINE_NR, 
               ORG_PHON_EXT_NR, 
               PRINT_DSTN_ID, 
               PARNT_SWB_ORG_CD, 
               HQ_SPEED_DIAL_CD, 
               AUDIT_INTG_CNTL_NR, 
               AUDIT_PWS_ID, 
               AUDIT_UPDT_DT, 
               AUDIT_UPDT_TM, 
               AUDIT_USER_ID
               INTO 
                 :L-CASHR-ORG-PROFL-F.SWB-ORG-CD, 
                 :L-CASHR-ORG-PROFL-F.SWB-ORG-NM, 
                 :L-CASHR-ORG-PROFL-F.ORG-COMTRACK-CD, 
                 :L-CASHR-ORG-PROFL-F.SWB-ORG-TYPE-CD, 
                 :L-CASHR-ORG-PROFL-F.ORG-FAX-AREA-CD, 
                 :L-CASHR-ORG-PROFL-F.ORG-FAX-PRFX-NR, 
                 :L-CASHR-ORG-PROFL-F.ORG-FAX-LINE-NR, 
                 :L-CASHR-ORG-PROFL-F.ORG-FAX-EXT-NR, 
                 :L-CASHR-ORG-PROFL-F.ORG-PHON-AREA-CD, 
                 :L-CASHR-ORG-PROFL-F.ORG-PHON-PRFX-NR, 
                 :L-CASHR-ORG-PROFL-F.ORG-PHON-LINE-NR, 
                 :L-CASHR-ORG-PROFL-F.ORG-PHON-EXT-NR, 
                 :L-CASHR-ORG-PROFL-F.PRINT-DSTN-ID-V, 
                 :L-CASHR-ORG-PROFL-F.PARNT-SWB-ORG-CD, 
                 :L-CASHR-ORG-PROFL-F.HQ-SPEED-DIAL-CD, 
                 :L-CASHR-ORG-PROFL-F.AUDIT-INTG-CNTL-NR, 
                 :L-AUDIT-DATA.AUDIT-PWS-ID, 
                 :L-AUDIT-DATA.AUDIT-UPDT-DT, 
                 :L-AUDIT-DATA.AUDIT-UPDT-TM, 
                 :L-AUDIT-DATA.AUDIT-USER-ID
               FROM CASHR_ORG_PROFL
               WHERE SWB_ORG_CD = :L-CASHR-ORG-PROFL-PK.SWB-ORG-CD
           END-EXEC.
           
      *
      ******************************************************************
      * **                                                              
      * **
      * **  SQL RETURN CODE CHECKING: Customize as required by the      
      * **
      * **                            application processing            
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           MOVE SQLCODE OF SQLCA
              TO RTRN-CD OF CASHR-ORG-PROFL-READ-SQL-O.
           
           EVALUATE SQLCODE OF SQLCA
             WHEN SUCCESS OF EXEC-STAT-CODES
               MOVE L-CASHR-ORG-PROFL-F
                  TO CASHR-ORG-PROFL-F OF CASHR-ORG-PROFL-READ-SQL-O
               MOVE L-AUDIT-DATA
                  TO AUDIT-DATA OF CASHR-ORG-PROFL-F OF 
                   CASHR-ORG-PROFL-READ-SQL-O
             WHEN OTHER
      *
      *-=R2C=- inset %sSQL-SOFT-ERR
      *
               PERFORM 
                 VARYING R2C-TEMPVAR-000
                 FROM 1
                 BY 1
                 UNTIL (R2C-TEMPVAR-000 > 7 OR SQLCODE OF SQLCA = ITEMS
                    OF SSSE001-LOOKUP (R2C-TEMPVAR-000))
                 
               END-PERFORM
               
               IF (R2C-TEMPVAR-000 <= 7) THEN
                 CONTINUE
               ELSE
                 MOVE 'CASHR_ORG_PROFL key = '
                    TO SQL-PARM-TX OF DB2-ERR-ROTN-I (1)
                 MOVE SWB-ORG-CD OF CASHR-ORG-PROFL-PK
                    TO SQL-PARM-TX OF DB2-ERR-ROTN-I (2)
                 MOVE CORRESPONDING SQLCA
                    TO SQLCA-VIEW OF DB2-ERR-ROTN-I
                 
                 PERFORM 
                   VARYING R2C-TEMPVAR-001
                   FROM 1
                   BY 1
                   UNTIL (R2C-TEMPVAR-001 > 6)
                   
                   MOVE SQLERRD OF SQLCA (R2C-TEMPVAR-001)
                      TO SQLERRD OF SQLCA-VIEW OF DB2-ERR-ROTN-I (
                       R2C-TEMPVAR-001)
                 END-PERFORM
                 
      *
      *-=R2C=- "RDER001" is short name for rule "DB2_ERR_ROTN"
      *
                 CALL 'RDER001' USING 
                   DB2-ERR-ROTN-I 
                   DB2-ERR-ROTN-O
                 
                 MOVE FAILURE OF EXEC-STAT-CODES
                    TO EXEC-STAT-CD OF CASHR-ORG-PROFL-READ-SQL-O
               END-IF
               
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.