       IDENTIFICATION DIVISION.
       PROGRAM-ID. RCOPR01.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RCOPR01
      *      LONG  Name - CASHR_ORG_PROFL_READ
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * CASHR_ORG_PROFL_READ_SQL       RCOPRS1
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  CASHR_ORG_PROFL_READ:                                       
      * **
      * **                  This rule is used to control the reads of   
      * **
      * **                  all DB2 tables which make up an entity.     
      * **
      * **                                                              
      * **
      * **                  Code is provided for a single table read.   
      * **
      * **                  If the entity is made up of more than one   
      * **
      * **                  table, you will need to repeat the logic    
      * **
      * **                  for loading the table file view and read    
      * **
      * **                  sql for each additional table.  The code to 
      * **
      * **                  do this is marked in the body of the rule.  
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RCOPR01'.
      *****************************************************************
      *ORG_PROFL_READ_VINPT_ERR_FLD               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 ORG-PROFL-READ-VINPT-ERR-FLD.
         COPY AFVFHD.
      *****************************************************************
      *ORG_PROFL_READ_VINPT_ERR_TX                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 ORG-PROFL-READ-VINPT-ERR-TX.
         COPY AFVGHD.
      *****************************************************************
      *PUBL_ERR_CD                                AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 PUBL-ERR-CD.
         COPY SPERRCD.
      *****************************************************************
      *FLD_STATUS_CODES                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 FLD-STATUS-CODES.
         COPY SFLDSTA.
      *****************************************************************
      *CASHR_ORG_PROFL_READ_SQL_I                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-ORG-PROFL-READ-SQL-I.
         COPY VCOPRSI1.
      *****************************************************************
      *CASHR_ORG_PROFL_READ_SQL_O                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-ORG-PROFL-READ-SQL-O.
         COPY VCOPRSO1.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- VCOPRI01
      *****************************************************************
      *CASHR_ORG_PROFL_READ_I                     AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-ORG-PROFL-READ-I.
         COPY VCOPRI01.
      * OUTPUT VIEW -- VCOPRO01
      *****************************************************************
      *CASHR_ORG_PROFL_READ_O                     AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 CASHR-ORG-PROFL-READ-O.
         COPY VCOPRO01.
      /
       PROCEDURE DIVISION
           USING CASHR-ORG-PROFL-READ-I CASHR-ORG-PROFL-READ-O.
       
       INIT-SECTION.
       
           INITIALIZE CASHR-ORG-PROFL-READ-SQL-I.
           INITIALIZE CASHR-ORG-PROFL-READ-O.
       
       A100-MAINLINE .
       
           MOVE 'RCOPR01'
              TO MODUL-ID OF CASHR-ORG-PROFL-READ-O.
      *
      ******************************************************************
      * **                                                              
      * **
      * **   FORMAT TABLE KEY and READ DB2:                             
      * **
      * **                                                              
      * **
      * **   Pass the entity key to the table read rule and invoke      
      * **
      * **   the table read.  If the entity is made up of more than     
      * **
      * **   a single table, repeat the logic below once for each       
      * **
      * **   table.  When dealing with multiple tables, be careful      
      * **
      * **   how you fill the entity view from the various table file   
      * **
      * **   views to be sure that you do not wipe out previously       
      * **
      * **   retrieved data.                                            
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
           MOVE CASHR-ORG-PROFL-PK OF CASHR-ORG-PROFL-READ-I
              TO CASHR-ORG-PROFL-PK OF CASHR-ORG-PROFL-READ-SQL-I.
      *
      *-=R2C=- "RCOPRS1" is short name for rule
      * "CASHR_ORG_PROFL_READ_SQL"
      *
           CALL 'RCOPRS1' USING 
             CASHR-ORG-PROFL-READ-SQL-I 
             CASHR-ORG-PROFL-READ-SQL-O.
           
           EVALUATE RTRN-CD OF CASHR-ORG-PROFL-READ-SQL-O
             WHEN SUCCESS OF PUBL-ERR-CD
               MOVE CORRESPONDING CASHR-ORG-PROFL-F OF 
                 CASHR-ORG-PROFL-READ-SQL-O
                  TO CASHR-ORG-PROFL OF CASHR-ORG-PROFL-ENT-GRP OF 
                   CASHR-ORG-PROFL-READ-O
               MOVE AUDIT-INTG-CNTL-NR OF CASHR-ORG-PROFL-F OF 
                 CASHR-ORG-PROFL-READ-SQL-O
                  TO AUDIT-INTG-CNTL-NR OF CASHR-ORG-PROFL-ENT-GRP OF 
                   CASHR-ORG-PROFL-READ-O
               MOVE AUDIT-DATA OF CASHR-ORG-PROFL-F OF 
                 CASHR-ORG-PROFL-READ-SQL-O
                  TO AUDIT-DATA OF CASHR-ORG-PROFL-ENT-GRP OF 
                   CASHR-ORG-PROFL-READ-O
             WHEN ROW-NOT-FOUND OF PUBL-ERR-CD
               MOVE SWB-ORG-CD OF ORG-PROFL-READ-VINPT-ERR-FLD
                  TO FLD-ID OF STD-FLD-INFO OF CASHR-ORG-PROFL-READ-O
               MOVE R2C-ERROR OF FLD-STATUS-CODES
                  TO FLD-STAT-CD OF STD-FLD-INFO OF 
                   CASHR-ORG-PROFL-READ-O
               MOVE ORG-NOT-FOUND OF ORG-PROFL-READ-VINPT-ERR-TX
                  TO FLD-MSG-CD OF STD-FLD-INFO OF 
                   CASHR-ORG-PROFL-READ-O
               MOVE 1
                  TO TOT-ERR-COUNT-NR OF STD-FLD-MSG-COUNTS OF 
                   CASHR-ORG-PROFL-READ-O
               MOVE 1
                  TO TOT-MSG-COUNT-NR OF STD-FLD-MSG-COUNTS OF 
                   CASHR-ORG-PROFL-READ-O
               MOVE STD-RTRN-DATA OF CASHR-ORG-PROFL-READ-SQL-O
                  TO STD-RTRN-DATA OF CASHR-ORG-PROFL-READ-O
             WHEN OTHER
               MOVE STD-RTRN-DATA OF CASHR-ORG-PROFL-READ-SQL-O
                  TO STD-RTRN-DATA OF CASHR-ORG-PROFL-READ-O
           END-EVALUATE.
           
      *
      * -=R2C=- added this exit point
      *
           GOBACK.