       IDENTIFICATION DIVISION.
       PROGRAM-ID. RADF001.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - RADF001
      *      LONG  Name - AUDIT_DATA_FRMT
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * DATE_TIME_SRVC                 RDTS001
      * EIBLK_READ                     CEIR001
      * EMP_SIGN_ON_ID_READ_CICS       CESOIRC
      * HPSMODE                        HPSMODE
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(41)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM RADF001'.
      *****************************************************************
      *EXEC_ENVRN_CD                              AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-ENVRN-CD.
         COPY SEXENCD.
      *****************************************************************
      *STD_ERR_CD                                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 STD-ERR-CD.
         COPY SSTDERR.
      *****************************************************************
      *DATE_TIME_SRVC_I                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-SRVC-I.
         COPY CGSDT01I.
      *****************************************************************
      *DATE_TIME_SRVC_O                           AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-SRVC-O.
         COPY CGSDT01O.
      *****************************************************************
      *EIBLK_READ_I                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EIBLK-READ-I.
         COPY CEIR001I.
      *****************************************************************
      *EIBLK_READ_O                               AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EIBLK-READ-O.
         COPY CEIR001O.
      *****************************************************************
      *EMP_SIGN_ON_ID_READ_CICS_I                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EMP-SIGN-ON-ID-READ-CICS-I.
         COPY CESOIRCI.
      *****************************************************************
      *EMP_SIGN_ON_ID_READ_CICS_O                 AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EMP-SIGN-ON-ID-READ-CICS-O.
         COPY CESOIRCO.
      *****************************************************************
      *HPSMODEO                                   AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 HPSMODEO.
         COPY HPSMODEO.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- RADFI001
      *****************************************************************
      *AUDIT_DATA_FRMT_I                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 AUDIT-DATA-FRMT-I.
         COPY RADFI001.
      * OUTPUT VIEW -- RADFO001
      *****************************************************************
      *AUDIT_DATA_FRMT_O                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 AUDIT-DATA-FRMT-O.
         COPY RADFO001.
      /
       PROCEDURE DIVISION
           USING AUDIT-DATA-FRMT-I AUDIT-DATA-FRMT-O.
       
       INIT-SECTION.
       
           INITIALIZE DATE-TIME-SRVC-I.
           INITIALIZE EIBLK-READ-I.
           INITIALIZE EMP-SIGN-ON-ID-READ-CICS-I.
           INITIALIZE AUDIT-DATA-FRMT-O.
       
       A100-MAINLINE .
       
           MOVE FAILURE OF STD-ERR-CD
              TO RTRN-CD OF AUDIT-DATA-FRMT-O.
      *
      *-=R2C=- "RDTS001" is short name for rule "DATE_TIME_SRVC"
      *
           CALL 'RDTS001' USING 
             DATE-TIME-SRVC-I 
             DATE-TIME-SRVC-O.
           
           EVALUATE RTRN-CD OF DATE-TIME-SRVC-O
             WHEN SUCCESS OF STD-ERR-CD
               MOVE CURR-DT OF DATE-TIME-SRVC-O
                  TO AUDIT-UPDT-DT OF AUDIT-DATA OF AUDIT-DATA-FRMT-O
               MOVE CURR-TM OF DATE-TIME-SRVC-O
                  TO AUDIT-UPDT-TM OF AUDIT-DATA OF AUDIT-DATA-FRMT-O
             WHEN OTHER
               MOVE FAILURE OF STD-ERR-CD
                  TO RTRN-CD OF AUDIT-DATA-FRMT-O
               GOBACK
           END-EVALUATE.
           
      *
      *-=R2C=- HPSMODE component is not converted - CICS is assumed.
      *
      *
      *-=R2C=- "CEIR001" is short name for component "EIBLK_READ"
      *
           CALL 'CEIR001' USING 
                 EIBLK-READ-I 
                 EIBLK-READ-O.
             
           EVALUATE RTRN-CD OF EIBLK-READ-O
             WHEN SUCCESS OF STD-ERR-CD
                  CONTINUE
             WHEN OTHER
                  MOVE RTRN-CD OF EIBLK-READ-O
                     TO RTRN-CD OF AUDIT-DATA-FRMT-O
                  GOBACK
           END-EVALUATE.
             
           MOVE TRML-ID OF DFHEIBLK-CMMD-AREA OF EIBLK-READ-O
             TO AUDIT-PWS-ID OF AUDIT-DATA OF AUDIT-DATA-FRMT-O.
      *
      *-=R2C=- "CESOIRC" is short name for component
      * "EMP_SIGN_ON_ID_READ_CICS"
      *
           CALL 'CESOIRC' USING 
               EMP-SIGN-ON-ID-READ-CICS-I 
               EMP-SIGN-ON-ID-READ-CICS-O.
             
           EVALUATE RTRN-CD OF EMP-SIGN-ON-ID-READ-CICS-O
             WHEN SUCCESS OF STD-ERR-CD
                  CONTINUE
             WHEN OTHER
                  MOVE RTRN-CD OF EMP-SIGN-ON-ID-READ-CICS-O
                     TO RTRN-CD OF AUDIT-DATA-FRMT-O
                  GOBACK
           END-EVALUATE.
             
           MOVE EMP-SIGN-ON-ID OF EMP-SIGN-ON-ID-READ-CICS-O
              TO AUDIT-USER-ID OF AUDIT-DATA OF AUDIT-DATA-FRMT-O.
           
           MOVE SUCCESS OF STD-ERR-CD
              TO RTRN-CD OF AUDIT-DATA-FRMT-O.
      *
      * -=R2C=- added this exit point
      *
           GOBACK.