       IDENTIFICATION DIVISION.
       PROGRAM-ID. ADDVMU.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - ADDVMU
      *      LONG  Name - SECURITY_ACCESS_VRFY
      *
      *   Amended by Relativity to return zero return code
      *   and dummy out call to Top Secret. 
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * GET_TOP_SECRET_INFO            ACQOHD
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1994 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  SECURITY_ACCESS_VRFY:                                       
      * **
      * **     This rule allows the PC window display rule to call the  
      * **
      * **     Top Secret component.                                    
      * **
      * **                                                              
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(40)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM ADDVMU'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
      *****************************************************************
      *GET_TOP_SECRET_INFO_I                      AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 GET-TOP-SECRET-INFO-I.
         COPY ZACQQHD.
      *****************************************************************
      *GET_TOP_SECRET_INFO_O                      AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 GET-TOP-SECRET-INFO-O.
         COPY ZACQRHD.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * INPUT VIEW -- ZADDWMU
      *****************************************************************
      *SECURITY_ACCESS_VRFY_I                     AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SECURITY-ACCESS-VRFY-I.
         COPY ZADDWMU.
      * OUTPUT VIEW -- ZADDXMU
      *****************************************************************
      *SECURITY_ACCESS_VRFY_O                     AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 SECURITY-ACCESS-VRFY-O.
         COPY ZADDXMU.
      /
       PROCEDURE DIVISION
           USING SECURITY-ACCESS-VRFY-I SECURITY-ACCESS-VRFY-O.
       
       INIT-SECTION.
       
           INITIALIZE GET-TOP-SECRET-INFO-I.
           INITIALIZE SECURITY-ACCESS-VRFY-O.
       
       A100-MAINLINE .
       
           MOVE 'ADDVMU'
              TO MODUL-ID OF STD-RTRN-DATA OF SECURITY-ACCESS-VRFY-O.
           MOVE FAILURE OF EXEC-STAT-CODES
              TO EXEC-STAT-CD OF STD-RTRN-DATA OF SECURITY-ACCESS-VRFY-O
               .
           MOVE SECURITY-ACCESS-VRFY-I
              TO GET-TOP-SECRET-INFO-I.
      *
      *-=R2C=- "ACQOHD" is short name for component
      * "GET_TOP_SECRET_INFO"
      *
      *    CALL 'ACQOHD' USING 
      *      GET-TOP-SECRET-INFO-I 
      *      GET-TOP-SECRET-INFO-O.
      *
           MOVE ZERO TO RTRN-CD OF GET-TOP-SECRET-INFO-O.
      *         
           IF (RTRN-CD OF GET-TOP-SECRET-INFO-O > 8) THEN
      *
      * rc > 8 - pretty serious return code from top secret
      * - set failure
      *
             MOVE RTRN-CD OF GET-TOP-SECRET-INFO-O
                TO RTRN-CD OF STD-RTRN-DATA OF SECURITY-ACCESS-VRFY-O
             GOBACK
           ELSE
      *
      * rc <= 8 are rcs that are expected after a call
      *
             MOVE SUCCESS OF EXEC-STAT-CODES
                TO EXEC-STAT-CD OF STD-RTRN-DATA OF 
                 SECURITY-ACCESS-VRFY-O
             MOVE RTRN-CD OF GET-TOP-SECRET-INFO-O
                TO RTRN-CD OF STD-RTRN-DATA OF SECURITY-ACCESS-VRFY-O
           END-IF.
           
           GOBACK.