       IDENTIFICATION DIVISION.
       PROGRAM-ID. AC8QHD.
      *
      *    OLD HPS NAMES:
      *      SHORT Name - AC8QHD
      *      LONG  Name - DATE_TIME_FRMT2
      *
      *******************************************************
      * CALLED-MODULES
      * -----------------------
      * HPS LONG NAME                  HPS SHORT NAME
      * -----------------------------------------------------
      * N/A
      *
      * TABLE-ID
      * -----------------------
      * N/A
      *
      *******************************************************
      *    TRANSFORMATION DATE/TIME: Wed Mar 23 16:44:09 2005.
      ******************************************************
      *             LIST OF MODIFICATIONS
      *
      *  DATE     PGMR        DESCRIPTION
      *
      * 03/23/05  Relativity  Preserved original HPS comments
      *
      *
      ******************************************************************
      * **                                                              
      * **
      * **  Copyright 1993 Charles Schwab & Co., Inc.                   
      * **
      * **  All rights reserved                                         
      * **
      * **                                                              
      * **
      * **                                                              
      * **
      * **  DATE_TIME_FRMT2:                                            
      * **
      * **                                                              
      * **
      * **     This rule is used to get the mainframe date & time in    
      * **
      * **     integer format.  It should be usable from both CICS      
      * **
      * **     & batch.                                                 
      * **
      * **                                                              
      * **
      * **     Date is returned as 00CCYYMMDD                           
      * **
      * **     Time is returned as 00HHMMSSTT                           
      * **
      * ***************************************************************
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
      *
      *****************************************************************
      ***   W O R K I N G     S T O R A G E      S E C T I O N       **
      *****************************************************************
      *
       WORKING-STORAGE SECTION.
       01 WS-GENERAL-WORK-AREAS.
         05 FILLER                  PIC X(40)
                                    VALUE 
           'BEGIN WORKING STORAGE FOR PROGRAM AC8QHD'.
      *****************************************************************
      *EXEC_STAT_CODES                            AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 EXEC-STAT-CODES.
         COPY SESC001.
       01 HPS-LOCAL-VARS.
         05 L-DATE                  PIC X(10).
         05 L-TIME                  PIC X(8).
         05 L-DATE-INT              PIC S9(9) COMP.
         05 L-TIME-INT              PIC S9(9) COMP.
       01 R2C-LOCAL-VARS.
         05 R2C-TEMPVAR-000.
           10 DATE-PART.
             15 YYYY                PIC 9999.
             15 MM                  PIC 99.
             15 DD                  PIC 99.
           10 TIME-PART.
             15 HH                  PIC 99.
             15 MM                  PIC 99.
             15 SS                  PIC 99.
             15 NN                  PIC 99.
           10 FILLER                PIC X(5).
         05 R2C-TEMPVAR-001.
           10 DATE-PART.
             15 YYYY                PIC 9999.
             15 FILLER              PIC X
                                    VALUE '-'.
             15 MM                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '-'.
             15 DD                  PIC 99.
           10 FILLER                PIC X
                                    VALUE '-'.
           10 TIME-PART.
             15 HH                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '.'.
             15 MM                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '.'.
             15 SS                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '.'.
             15 NN                  PIC 9(6).
         05 R2C-TEMPVAR-002.
           10 DATE-PART.
             15 YYYY                PIC 9999.
             15 MM                  PIC 99.
             15 DD                  PIC 99.
           10 TIME-PART.
             15 HH                  PIC 99.
             15 MM                  PIC 99.
             15 SS                  PIC 99.
             15 NN                  PIC 99.
           10 FILLER                PIC X(5).
         05 R2C-TEMPVAR-003.
           10 DATE-PART.
             15 YYYY                PIC 9999.
             15 FILLER              PIC X
                                    VALUE '-'.
             15 MM                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '-'.
             15 DD                  PIC 99.
           10 FILLER                PIC X
                                    VALUE '-'.
           10 TIME-PART.
             15 HH                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '.'.
             15 MM                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '.'.
             15 SS                  PIC 99.
             15 FILLER              PIC X
                                    VALUE '.'.
             15 NN                  PIC 9(6).
         05 R2C-TEMPVAR-004.
           10 YYYY                  PIC 9999.
           10 MM                    PIC 99.
           10 DD                    PIC 99.
         05 R2C-TEMPVAR-005         REDEFINES R2C-TEMPVAR-004
                                    PIC 9(8).
         05 R2C-TEMPVAR-006.
           10 YYYY                  PIC 9999.
           10 FILLER                PIC X
                                    VALUE '-'.
           10 MM                    PIC 99.
           10 FILLER                PIC X
                                    VALUE '-'.
           10 DD                    PIC 99.
         05 R2C-TEMPVAR-007.
           10 HH                    PIC 99.
           10 MM                    PIC 99.
           10 SS                    PIC 99.
           10 NN                    PIC 99.
         05 R2C-TEMPVAR-008         REDEFINES R2C-TEMPVAR-007
                                    PIC 9(8).
         05 R2C-TEMPVAR-009.
           10 HH                    PIC 99.
           10 FILLER                PIC X
                                    VALUE '.'.
           10 MM                    PIC 99.
           10 FILLER                PIC X
                                    VALUE '.'.
           10 SS                    PIC 99.
         05 R2C-TEMPVAR-010         PIC S9(11) COMP-3.
      *
      *****************************************************************
      ***              L I N K A G E          S E C T I O N          **
      *****************************************************************
      *
       LINKAGE SECTION.
      * OUTPUT VIEW -- ZAC8UHD
      *****************************************************************
      *DATE_TIME_FRMT2_O                          AREAS(COBOL COPYBOOK)
      *****************************************************************
       01 DATE-TIME-FRMT2-O.
         COPY ZAC8UHD.
      /
       PROCEDURE DIVISION
           USING DATE-TIME-FRMT2-O.
       
       INIT-SECTION.
       
           INITIALIZE HPS-LOCAL-VARS.
       
       A100-MAINLINE .
       
           MOVE FAILURE OF EXEC-STAT-CODES
              TO EXEC-STAT-CD OF DATE-TIME-FRMT2-O.
           MOVE 'AC8QHD'
              TO MODUL-ID OF DATE-TIME-FRMT2-O.
           MOVE FUNCTION CURRENT-DATE
              TO R2C-TEMPVAR-000 OF R2C-LOCAL-VARS.
           MOVE CORRESPONDING R2C-TEMPVAR-000 OF R2C-LOCAL-VARS
              TO R2C-TEMPVAR-001.
           MOVE DATE-PART OF R2C-TEMPVAR-001 OF R2C-LOCAL-VARS
              TO L-DATE.
           MOVE FUNCTION CURRENT-DATE
              TO R2C-TEMPVAR-002 OF R2C-LOCAL-VARS.
           MOVE CORRESPONDING R2C-TEMPVAR-002 OF R2C-LOCAL-VARS
              TO R2C-TEMPVAR-003.
           COMPUTE NN OF TIME-PART OF R2C-TEMPVAR-003 OF R2C-LOCAL-VARS
              = (NN OF TIME-PART OF R2C-TEMPVAR-002 OF R2C-LOCAL-VARS * 
             10000).
           MOVE TIME-PART OF R2C-TEMPVAR-003 OF R2C-LOCAL-VARS
              TO L-TIME.
           MOVE L-DATE
              TO R2C-TEMPVAR-006.
           MOVE CORRESPONDING R2C-TEMPVAR-006
              TO R2C-TEMPVAR-004.
           MOVE R2C-TEMPVAR-005
              TO L-DATE-INT.
           MOVE L-TIME
              TO R2C-TEMPVAR-009.
           MOVE CORRESPONDING R2C-TEMPVAR-009
              TO R2C-TEMPVAR-007.
           COMPUTE L-TIME-INT = (R2C-TEMPVAR-008 * 10).
           MOVE L-DATE-INT
              TO CURR-DT OF DATE-TIME-FRMT2-O.
           COMPUTE R2C-TEMPVAR-010 = (L-TIME-INT / 10).
           MOVE R2C-TEMPVAR-010
              TO CURR-TM OF DATE-TIME-FRMT2-O.
           MOVE SUCCESS OF EXEC-STAT-CODES
              TO EXEC-STAT-CD OF DATE-TIME-FRMT2-O.
      *
      * -=R2C=- added this exit point
      *
           GOBACK.