package com.ibm.ie.reeng.rt.servletserv;

import com.ibm.ie.reeng.rt.common.Config;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;

import javax.servlet.ServletException;

/**
 * This class is responsible for using JNDI to look up paramenters for
 * various aspects of the runtime behaviour of the reengineered server.
 */
class ConfigSource implements Config.Source
{
    // Indicates whether the App Server uses JNDI for environment
    // properties (EJB 1.1)
    public static final boolean JNDI_ENV_PROPERTIES = false;

    ConfigSource()
    {
        try
        {
            Context initial = new InitialContext();
            environment = (Context)initial.lookup("java:comp/env");
        }
        catch (NamingException ex) 
        { 
            System.out.println("Naming exception - Can't find java:comp/env - Running as standalone?  If so, ignore naming errors");
            fatalException(ex); 
        }
    }

    private Context environment;

    private Object getEnvEntry(String key)
    {
        System.out.println("ConfigSource: looking up " + key);

        try
        {
            Object o = environment.lookup(key);
            System.out.println("ConfigSource.getEnvEntry() - returning " + o);
            return o;
        }
        catch (NamingException ex)
        {
            System.out.println("ConfigSource.getEnvEntry() - exception " + ex);
        }
        return null;
    }

    public String getString(String key)
    {
        try
        {
            return (String)getEnvEntry(key);
        }
        catch (ClassCastException e)
        {
            System.out.println("ConfigSource: ERROR " + key + " is not bound to a String");
            return null;
        }
    }

    public boolean getBoolean(String key)
    {
        try
        {
            Boolean b = (Boolean)getEnvEntry(key);
            return b != null && b.booleanValue();
        }
        catch (ClassCastException e)
        {
            System.out.println("ConfigSource: ERROR " + key + " is not bound to a Boolean");
            return false;
        }
    }

    public Integer getInteger(String key)
    {
        try
        {
            return (Integer)getEnvEntry(key);
        }
        catch (ClassCastException e)
        {
            System.out.println("ConfigSource: ERROR " + key + " is not bound to an Integer");
            return null;
        }
    }

    public int getInt(String key)
    {
        Integer i = getInteger(key);

        if (i != null) return i.intValue();

        System.out.println("ConfigSource: ERROR " + key + " should be manditory");
        return -1;
    }

    private void fatalException(Exception e)
    {
        System.err.println("FATAL ERROR:");
        e.printStackTrace(System.err);
        // For the moment, use a runtime exception
        throw new RuntimeException("FATAL ERROR in configuration");
    }
}
