package com.ibm.ie.reeng.rt.servletserv;

import com.ibm.ie.reeng.rt.common.Log;

/**
 * The base class for all user and system components. We don't yet
 * support calling user components from EJB.
 */
public abstract class Component
extends com.ibm.ie.reeng.rt.common.Component
{

    /**
     * Subclasses must implement this to provide the component logic.
     * Since subclasses only want to implement one of these
     * we'll provide empty implementations here (rather than specify 
     * abstract methods).
     */
    protected void execute(State ctx) { Log.fatalError(this, "execute(State) not defined"); }
    protected void execute() { Log.fatalError(this, "excecute() not defined!"); }

    /**
     * Excecutes the component logic. This is the public (user's)
     * interface to the component.
     */
    public void use() { use(null); }
    public void use(State ctx)
    {
        prepareToExecute();
        if (ctx == null)
            execute();
        else
            execute(ctx);
    }
}
