package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.servlet.JSPComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.MenuItemAttributes;
import com.ibm.ie.reeng.rt.common.set.MenuItemState;
import com.ibm.ie.reeng.rt.common.view.SetMenuModeByIdI;
import com.ibm.ie.reeng.rt.common.view.SetMenuModeByIdO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;
import com.ibm.ie.reeng.rt.servlet.HtmlToken;
import com.ibm.ie.reeng.rt.common.Log;


import java.util.ArrayList;

public class SetMenuModeById extends SystemComponent
{
    /** Input view. */
    public SetMenuModeByIdI in = new SetMenuModeByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetMenuModeByIdO out = new SetMenuModeByIdO();

    protected void clearOutputView() { out.clear(); }

    public final static String TYPE = "MENU_MODE";


    private static class JspData extends JSPComponent
    {
        private String identifier;
        private int attribute, state;


        public JspData(String identifier, int attribute, int state)
        {
            this.identifier = identifier;
            this.attribute = attribute;
            this.state = state;
        }


        public ArrayList use(ArrayList htmlList, String guiType)
        {
            HtmlToken htmlToken = null;        

            if (attribute == MenuItemAttributes.ENABLE)
            {
                if(state == MenuItemState.HPS_OFF)
                {
                    //Remove href tags by replacing the html 
                    //data with the value data

                    //Extract value data
                    for(int i=0; i<htmlList.size(); i++)
                    {
                        htmlToken = (HtmlToken)htmlList.get(i);
            
                        String tag = htmlToken.getTag();
            
                        //valueTag = temp tag used to identify label text and href text
                        if( tag.equals("value") || tag.equals("valueTag"))
                        {   
                            break; //end for loop
                        }
                    }
                    
                                        
                    //Clear token list
                    htmlList.clear();
          
                    //New format of data
                    //<a disabled>value</a>
                                        
                    htmlList.add(new HtmlToken("<a disabled>"));
                    
                    //Add value data to list.
                    if(htmlToken != null)
                        htmlList.add(htmlToken);

                    htmlList.add(new HtmlToken("</a>"));

                }
            }
            else  //check  MenuItemAttributes.CHECK
            {
                Log.warning("SetMenuModeById", "check menu option not implemented");
            }


            return htmlList;
        }
    }


    public void execute(SessionData sessionData)
    {
        sessionData.jsp.addComponent(in.hpsItemId,
                         new JspData(in.hpsItemId,
                                     in.hpsMitemAttribute,
                                     in.hpsMitemState),
                         TYPE);
        
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
